/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.cl.converter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.allcolor.xml.parser.dom.ANode;
import org.allcolor.xml.parser.dom.CDom2HTMLDocument;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDocumentCut {
    private static IHtmlToPdfTransformer.PageSize getPageSize(String sSize, IHtmlToPdfTransformer.PageSize size) {
        if (sSize == null || "".equals(sSize.trim())) {
            return size;
        }
        try {
            Field f = IHtmlToPdfTransformer.class.getDeclaredField(sSize);
            if (f != null) {
                return (IHtmlToPdfTransformer.PageSize)f.get(null);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            String[] array = sSize.split(",");
            if (array.length == 2) {
                return new IHtmlToPdfTransformer.PageSize(Double.parseDouble(array[0]), Double.parseDouble(array[1]));
            }
            if (array.length == 3) {
                return new IHtmlToPdfTransformer.PageSize(Double.parseDouble(array[0]), Double.parseDouble(array[1]), Double.parseDouble(array[2]));
            }
            if (array.length == 6) {
                return new IHtmlToPdfTransformer.PageSize(Double.parseDouble(array[0]), Double.parseDouble(array[1]), Double.parseDouble(array[2]), Double.parseDouble(array[3]), Double.parseDouble(array[4]), Double.parseDouble(array[5]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public static DocumentAndSize[] cut(Document doc, IHtmlToPdfTransformer.PageSize size) {
        NodeList nl = doc.getElementsByTagNameNS("http://www.allcolor.org/xmlns/yahp", "pb");
        if (nl.getLength() == 0) {
            nl = doc.getElementsByTagName("yahp:pb");
        }
        if (nl.getLength() == 0) {
            return new DocumentAndSize[]{new DocumentAndSize(doc, size)};
        }
        PbDocument[] pbdocs = CDocumentCut.getPbDocs(nl);
        DocumentAndSize[] array = new DocumentAndSize[pbdocs.length];
        for (int i = 0; i < pbdocs.length; ++i) {
            Node Sibling;
            Element parentPb;
            PbDocument pbdoc = pbdocs[i];
            Element pbstart = pbdoc.getPbStart();
            Element pbend = pbdoc.getPbEnd();
            IHtmlToPdfTransformer.PageSize tmpSize = CDocumentCut.getPageSize(pbstart == null ? null : pbstart.getAttribute("size"), size);
            CDom2HTMLDocument ndoc = new CDom2HTMLDocument();
            ndoc.setDocumentURI(doc.getDocumentURI());
            ANode.CNamespace xmlnsdef = new ANode.CNamespace(pbend != null ? pbend.getPrefix() : pbstart.getPrefix(), "http://www.allcolor.org/xmlns/yahp");
            ndoc.getNamespaceList().add(xmlnsdef);
            if (pbend == null) {
                parentPb = (Element)ndoc.adoptNode(pbstart.getParentNode().cloneNode(false));
                for (Sibling = pbstart.getNextSibling(); Sibling != null; Sibling = Sibling.getNextSibling()) {
                    Node node = ndoc.adoptNode(Sibling.cloneNode(true));
                    parentPb.appendChild(node);
                }
                Node nextNode = null;
                Node ppr = null;
                for (Node parent = pbstart.getParentNode(); parent != null; parent = parent.getParentNode()) {
                    if (parent.getNodeType() != 1) continue;
                    Node node = ndoc.adoptNode(parent.cloneNode(false));
                    if (nextNode != null) {
                        node.appendChild(nextNode);
                        if (!"body".equals(ppr.getNodeName())) {
                            for (Sibling = ppr.getNextSibling(); Sibling != null; Sibling = Sibling.getNextSibling()) {
                                Node n = ndoc.adoptNode(Sibling.cloneNode(true));
                                node.appendChild(n);
                            }
                        }
                        nextNode = node;
                    } else {
                        nextNode = parentPb;
                    }
                    ppr = parent;
                }
                ndoc.appendChild(nextNode);
            } else {
                parentPb = (Element)ndoc.adoptNode(pbend.getParentNode().cloneNode(false));
                boolean hasbeendes = false;
                for (Sibling = pbend.getPreviousSibling(); !hasbeendes && Sibling != null; Sibling = Sibling.getPreviousSibling()) {
                    if (CDocumentCut.isDescendant(pbstart, Sibling)) {
                        hasbeendes = true;
                        break;
                    }
                    Node node = ndoc.adoptNode(Sibling.cloneNode(true));
                    if (parentPb.getChildNodes().getLength() == 0) {
                        parentPb.appendChild(node);
                        continue;
                    }
                    parentPb.insertBefore(node, parentPb.getFirstChild());
                }
                if (hasbeendes && pbstart != Sibling) {
                    Node tmp;
                    Node pb;
                    Node c = ndoc.adoptNode(Sibling.cloneNode(true));
                    ((Element)c).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:yahp", "http://www.allcolor.org/xmlns/yahp");
                    Node p = pb = ((Element)c).getElementsByTagNameNS("http://www.allcolor.org/xmlns/yahp", "pb").item(0);
                    Node pp = pb.getParentNode().getPreviousSibling();
                    while (p != null) {
                        tmp = p.getPreviousSibling();
                        p.getParentNode().removeChild(p);
                        p = tmp;
                    }
                    while (pp != null) {
                        tmp = pp.getPreviousSibling();
                        if (tmp == null) {
                            Node ppz = pp.getParentNode();
                            if (ppz.getPreviousSibling() != null) {
                                tmp = ppz.getPreviousSibling();
                            } else {
                                Node prev = null;
                                while (prev == null && (ppz = ppz.getParentNode()) != null) {
                                    prev = ppz.getPreviousSibling();
                                }
                                if (prev != null) {
                                    tmp = prev;
                                }
                            }
                        }
                        pp.getParentNode().removeChild(pp);
                        pp = tmp;
                    }
                    if (parentPb.getChildNodes().getLength() == 0) {
                        parentPb.appendChild(c);
                    } else {
                        parentPb.insertBefore(c, parentPb.getFirstChild());
                    }
                }
                Node previousNode = null;
                Node ppr = null;
                for (Node parent = pbend.getParentNode(); parent != null; parent = parent.getParentNode()) {
                    if (parent.getNodeType() != 1) continue;
                    if (previousNode != null) {
                        Node node = ndoc.adoptNode(parent.cloneNode(false));
                        node.appendChild(previousNode);
                        if (!"body".equals(ppr.getNodeName())) {
                            for (Sibling = ppr.getPreviousSibling(); !hasbeendes && Sibling != null; Sibling = Sibling.getPreviousSibling()) {
                                if (CDocumentCut.isDescendant(pbstart, Sibling)) {
                                    if (pbstart != Sibling) {
                                        Node tmp;
                                        Node pb;
                                        Node c = ndoc.adoptNode(Sibling.cloneNode(true));
                                        Node p = pb = ((Element)c).getElementsByTagNameNS("http://www.allcolor.org/xmlns/yahp", "pb").item(0);
                                        Node pp = pb.getParentNode().getPreviousSibling();
                                        while (p != null) {
                                            tmp = p.getPreviousSibling();
                                            p.getParentNode().removeChild(p);
                                            p = tmp;
                                        }
                                        while (pp != null) {
                                            tmp = pp.getPreviousSibling();
                                            if (tmp == null) {
                                                Node ppz = pp.getParentNode();
                                                if (ppz.getPreviousSibling() != null) {
                                                    tmp = ppz.getPreviousSibling();
                                                } else {
                                                    Node prev = null;
                                                    while (prev == null && (ppz = ppz.getParentNode()) != null) {
                                                        prev = ppz.getPreviousSibling();
                                                    }
                                                    if (prev != null) {
                                                        tmp = prev;
                                                    }
                                                }
                                            }
                                            pp.getParentNode().removeChild(pp);
                                            pp = tmp;
                                        }
                                        if (node.getChildNodes().getLength() == 0) {
                                            node.appendChild(c);
                                        } else {
                                            node.insertBefore(c, node.getFirstChild());
                                        }
                                    }
                                    hasbeendes = true;
                                    break;
                                }
                                Node n = ndoc.adoptNode(Sibling.cloneNode(true));
                                if (node.getChildNodes().getLength() == 0) {
                                    node.appendChild(n);
                                    continue;
                                }
                                node.insertBefore(n, node.getFirstChild());
                            }
                        }
                        previousNode = node;
                    } else {
                        previousNode = parentPb;
                    }
                    ppr = parent;
                }
                ndoc.appendChild(previousNode);
            }
            CDocumentCut.copyHeader(doc, (Document)ndoc);
            array[i] = new DocumentAndSize((Document)ndoc, tmpSize);
        }
        return array;
    }

    private static boolean isDescendant(Node n, Node ref) {
        if (ref == null) {
            return false;
        }
        if (n == ref) {
            return true;
        }
        NodeList nl = ref.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            boolean result = CDocumentCut.isDescendant(n, nl.item(i));
            if (!result) continue;
            return result;
        }
        return false;
    }

    private static PbDocument[] getPbDocs(NodeList nl) {
        ArrayList<PbDocument> list = new ArrayList<PbDocument>();
        Element prevpb = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element pb = (Element)nl.item(i);
            PbDocument pbdoc = new PbDocument(prevpb, pb);
            list.add(pbdoc);
            prevpb = pb;
            if (i != nl.getLength() - 1) continue;
            pbdoc = new PbDocument(pb, null);
            list.add(pbdoc);
        }
        PbDocument[] array = new PbDocument[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (PbDocument)list.get(i);
        }
        return array;
    }

    private static void copyHeader(Document doc, Document ndoc) {
        NodeList headnl = doc.getElementsByTagName("head");
        if (headnl.getLength() > 0) {
            Element head = (Element)headnl.item(0);
            ndoc.getDocumentElement().insertBefore(ndoc.adoptNode(head.cloneNode(true)), ndoc.getDocumentElement().getFirstChild());
        }
    }

    private static class PbDocument {
        Element pbEnd;
        Element pbStart;

        public PbDocument(Element pbStart, Element pbEnd) {
            this.pbStart = pbStart;
            this.pbEnd = pbEnd;
        }

        public Element getPbEnd() {
            return this.pbEnd;
        }

        public Element getPbStart() {
            return this.pbStart;
        }
    }

    public static class DocumentAndSize {
        final Document doc;
        final IHtmlToPdfTransformer.PageSize size;

        public Document getDoc() {
            return this.doc;
        }

        public IHtmlToPdfTransformer.PageSize getSize() {
            return this.size;
        }

        public DocumentAndSize(Document doc, IHtmlToPdfTransformer.PageSize size) {
            this.doc = doc;
            this.size = size;
        }
    }
}

