/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.cl.converter;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Meta;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.allcolor.yahp.cl.converter.CHtmlToPdfFlyingSaucerTransformer;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer;

public class CDocumentReconstructor {
    private static final int getSecurityFlags(Map properties) {
        int securityType = 0;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_PRINTING")) ? securityType | 0x804 : securityType;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_MODIFY_CONTENTS")) ? securityType | 8 : securityType;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_COPY")) ? securityType | 0x10 : securityType;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_MODIFT_ANNOTATIONS")) ? securityType | 0x20 : securityType;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_FILLIN")) ? securityType | 0x100 : securityType;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_SCREEN_READERS")) ? securityType | 0x200 : securityType;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_ASSEMBLY")) ? securityType | 0x400 : securityType;
        securityType = "true".equals(properties.get("yahp.PDF_ALLOW_DEGRADED_PRINTING")) ? securityType | 4 : securityType;
        return securityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconstruct(List files, Map properties, OutputStream fout, String base_url, String producer, IHtmlToPdfTransformer.PageSize[] size, List hf) throws IHtmlToPdfTransformer.CConvertException {
        OutputStream out = fout;
        OutputStream out2 = fout;
        boolean signed = false;
        OutputStream oldOut = null;
        File tmp = null;
        File tmp2 = null;
        try {
            tmp = File.createTempFile("yahp", "pdf");
            tmp2 = File.createTempFile("yahp", "pdf");
            oldOut = out;
            if ("true".equals(properties.get("yahp.USE_PDF_SIGNING"))) {
                signed = true;
                out2 = new FileOutputStream(tmp2);
            } else {
                out2 = oldOut;
            }
            out = new FileOutputStream(tmp);
            Document document = null;
            PdfCopy writer = null;
            boolean first = true;
            HashMap<String, String> mapSizeDoc = new HashMap<String, String>();
            int totalPage = 0;
            for (int i = 0; i < files.size(); ++i) {
                File fPDF = (File)files.get(i);
                PdfReader reader = new PdfReader(fPDF.getAbsolutePath());
                reader.consolidateNamedDestinations();
                int n = reader.getNumberOfPages();
                if (first) {
                    String sproducer;
                    String title;
                    first = false;
                    document = new Document(reader.getPageSizeWithRotation(1));
                    writer = new PdfCopy(document, out);
                    writer.setPdfVersion('3');
                    writer.setFullCompression();
                    if ("true".equals(properties.get("yahp.USE_PDF_ENCRYPTION"))) {
                        String password = (String)properties.get("yahp.PDF_ENCRYPTION_PASSWORD");
                        int securityType = CDocumentReconstructor.getSecurityFlags(properties);
                        writer.setEncryption(1, password, null, securityType);
                    }
                    if ((title = (String)properties.get("yahp.PDF_TITLE")) != null) {
                        document.addTitle(title);
                    } else if (base_url != null) {
                        document.addTitle(base_url);
                    }
                    String creator = (String)properties.get("yahp.PDF_CREATOR");
                    if (creator != null) {
                        document.addCreator(creator);
                    } else {
                        document.addCreator("YaHP Converter v1.3 \u00c2\u00a720111121");
                    }
                    String author = (String)properties.get("yahp.PDF_AUTHOR");
                    if (author != null) {
                        document.addAuthor(author);
                    }
                    if ((sproducer = (String)properties.get("yahp.PDF_PRODUCER")) != null) {
                        document.add((Element)new Meta("Producer", sproducer));
                    } else {
                        document.add((Element)new Meta("Producer", "YaHP Converter v1.3 \u00c2\u00a720111121 - http://www.allcolor.org/YaHPConverter/ - " + producer));
                    }
                    document.open();
                }
                int j = 0;
                while (j < n) {
                    mapSizeDoc.put("" + ++totalPage, "" + i);
                    PdfImportedPage page = writer.getImportedPage(reader, ++j);
                    writer.addPage(page);
                }
            }
            document.close();
            out.flush();
            out.close();
            PdfReader reader = new PdfReader(tmp.getAbsolutePath());
            int n = reader.getNumberOfPages();
            PdfStamper stp = new PdfStamper(reader, out2);
            int i = 0;
            BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            CHtmlToPdfFlyingSaucerTransformer trans = new CHtmlToPdfFlyingSaucerTransformer();
            while (i < n) {
                int indexSize = Integer.parseInt((String)mapSizeDoc.get("" + ++i));
                int[] dsize = size[indexSize].getSize();
                int[] dmargin = size[indexSize].getMargin();
                Iterator it = hf.iterator();
                while (it.hasNext()) {
                    IHtmlToPdfTransformer.CHeaderFooter chf = (IHtmlToPdfTransformer.CHeaderFooter)it.next();
                    if (chf.getSfor().equals("odd") && i % 2 == 0 || chf.getSfor().equals("even") && i % 2 != 0) continue;
                    String text = chf.getContent().replaceAll("<pagenumber>", "" + i).replaceAll("<pagecount>", "" + n);
                    PdfContentByte over = stp.getOverContent(i);
                    ByteArrayOutputStream bbout = new ByteArrayOutputStream();
                    if (chf.getType().equals("header")) {
                        trans.transform((InputStream)new ByteArrayInputStream(text.getBytes("utf-8")), base_url, new IHtmlToPdfTransformer.PageSize(dsize[0] - (dmargin[0] + dmargin[1]), dmargin[3]), new ArrayList(), properties, (OutputStream)bbout);
                    } else if (chf.getType().equals("footer")) {
                        trans.transform((InputStream)new ByteArrayInputStream(text.getBytes("utf-8")), base_url, new IHtmlToPdfTransformer.PageSize(dsize[0] - (dmargin[0] + dmargin[1]), dmargin[2]), new ArrayList(), properties, (OutputStream)bbout);
                    }
                    PdfReader readerHF = new PdfReader(bbout.toByteArray());
                    if (chf.getType().equals("header")) {
                        over.addTemplate((PdfTemplate)stp.getImportedPage(readerHF, 1), (float)dmargin[0], (float)(dsize[1] - dmargin[3]));
                    } else if (chf.getType().equals("footer")) {
                        over.addTemplate((PdfTemplate)stp.getImportedPage(readerHF, 1), (float)dmargin[0], 0.0f);
                    }
                    readerHF.close();
                }
            }
            stp.close();
            try {
                out2.flush();
            }
            catch (Exception ignore) {
            }
            finally {
                try {
                    out2.close();
                }
                catch (Exception ignore) {}
            }
            if (signed) {
                String keypassword = (String)properties.get("yahp.PDF_SIGNING_PRIVATE_KEY_PASSWORD");
                String password = (String)properties.get("yahp.PDF_ENCRYPTION_PASSWORD");
                String keyStorepassword = (String)properties.get("yahp.PDF_SIGNING_KEYSTORE_PASSWORD");
                String privateKeyFile = (String)properties.get("yahp.PDF_SIGNING_PRIVATE_KEY_FILE");
                String reason = (String)properties.get("yahp.PDF_SIGNING_REASON");
                String location = (String)properties.get("yahp.PDF_SIGNING_LOCATION");
                boolean selfSigned = !"false".equals(properties.get("yahp.USE_PDF_SELF_SIGNING"));
                PdfReader reader2 = null;
                reader2 = password != null ? new PdfReader(tmp2.getAbsolutePath(), password.getBytes()) : new PdfReader(tmp2.getAbsolutePath());
                KeyStore ks = selfSigned ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance("pkcs12");
                ks.load(new FileInputStream(privateKeyFile), keyStorepassword.toCharArray());
                String alias = ks.aliases().nextElement();
                PrivateKey key = (PrivateKey)ks.getKey(alias, keypassword.toCharArray());
                Certificate[] chain = ks.getCertificateChain(alias);
                PdfStamper stp2 = PdfStamper.createSignature((PdfReader)reader2, (OutputStream)oldOut, (char)'\u0000');
                if ("true".equals(properties.get("yahp.USE_PDF_ENCRYPTION"))) {
                    stp2.setEncryption(1, password, null, CDocumentReconstructor.getSecurityFlags(properties));
                }
                PdfSignatureAppearance sap = stp2.getSignatureAppearance();
                if (selfSigned) {
                    sap.setCrypto(key, chain, null, PdfSignatureAppearance.SELF_SIGNED);
                } else {
                    sap.setCrypto(key, chain, null, PdfSignatureAppearance.WINCER_SIGNED);
                }
                if (reason != null) {
                    sap.setReason(reason);
                }
                if (location != null) {
                    sap.setLocation(location);
                }
                stp2.close();
                oldOut.flush();
            }
        }
        catch (Exception e) {
            throw new IHtmlToPdfTransformer.CConvertException("ERROR: An Exception occured while reconstructing the pdf document: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                tmp.delete();
            }
            catch (Exception ignore) {}
            try {
                tmp2.delete();
            }
            catch (Exception ignore) {}
        }
    }
}

