/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.allcolor.yahp.converter.CBASE64Codec;
import org.allcolor.yahp.converter.CByteArrayUrlConnection;

public class CJarLoaderURLStreamHandler
extends URLStreamHandler {
    private static CJarLoaderURLStreamHandler handler = new CJarLoaderURLStreamHandler();
    private Map preload = new Hashtable();

    public static CJarLoaderURLStreamHandler getInstance() {
        return handler;
    }

    public void addClassPreload(String path, byte[] array) {
        try {
            this.preload.put(path, new SoftReference<CGCCleaner>(new CGCCleaner(path, array)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final byte[] loadByteArray(InputStream in) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            int iNbByteRead = -1;
            while ((iNbByteRead = in.read(buffer)) != -1) {
                bOut.write(buffer, 0, iNbByteRead);
            }
            return bOut.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadByteArray(URL urlToResource) {
        InputStream in = null;
        try {
            URLConnection uc = urlToResource.openConnection();
            uc.setUseCaches(false);
            in = uc.getInputStream();
            byte[] byArray = CJarLoaderURLStreamHandler.loadByteArray(in);
            return byArray;
        }
        catch (IOException ioe) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignore) {}
        }
    }

    protected URLConnection openConnection(URL u) throws IOException {
        String up = u.toExternalForm();
        String path = u.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.preload.containsKey(up)) {
            SoftReference ref = (SoftReference)this.preload.get(up);
            CGCCleaner cleaner = (CGCCleaner)ref.get();
            if (cleaner == null) {
                try {
                    this.preload.remove(up);
                }
                catch (Exception ignore) {}
            } else {
                byte[] array = (byte[])cleaner.get();
                return new CByteArrayUrlConnection(u, array);
            }
        }
        URL file = new URL(new String(CBASE64Codec.decode(u.getHost()), "utf-8"));
        JarInputStream in = new JarInputStream(file.openStream());
        JarEntry entry = null;
        while ((entry = in.getNextJarEntry()) != null && !entry.getName().equals(path)) {
            URL newU = new URL("yahpjarloader://" + u.getHost() + "/" + entry.getName());
            this.addClassPreload(newU.toExternalForm(), CJarLoaderURLStreamHandler.loadByteArray(in));
        }
        if (entry == null) {
            in.close();
            throw new IOException("Resource not found ! : " + path + " - " + file.toExternalForm());
        }
        byte[] array = CJarLoaderURLStreamHandler.loadByteArray(in);
        in.close();
        return new CByteArrayUrlConnection(u, array);
    }

    public static class CGCCleaner {
        String name;
        Object ref;

        CGCCleaner(String name, Object ref) {
            this.name = name;
            this.ref = ref;
        }

        public void finalize() throws Throwable {
            super.finalize();
            if (handler.preload.containsKey(this.name)) {
                handler.preload.remove(this.name);
            }
        }

        public Object get() {
            return this.ref;
        }
    }
}

