/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.converter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.allcolor.yahp.converter.CClassLoader;
import org.allcolor.yahp.converter.CClassLoaderConfig;
import org.allcolor.yahp.converter.CMutex;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer;

public final class CYaHPConverter {
    private static final CMutex countMutex;
    private static int countInstance;
    private final CMutex mutex = new CMutex();
    private Map transformers = new HashMap();
    private final boolean useClassLoader;
    private static List fileToDeleteOnDestroy;

    public CYaHPConverter() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CYaHPConverter(boolean useClassLoader) {
        this.useClassLoader = useClassLoader;
        try {
            countMutex.acquire();
            ++countInstance;
            this.init(useClassLoader);
        }
        finally {
            try {
                countMutex.release();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        try {
            countMutex.acquire();
            for (int i = 0; i < fileToDeleteOnDestroy.size(); ++i) {
                File f = (File)fileToDeleteOnDestroy.get(i);
                if (f == null || !f.exists()) continue;
                try {
                    f.delete();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CClassLoader.destroy();
        }
        finally {
            countInstance = 0;
            try {
                countMutex.release();
            }
            catch (Exception exception) {}
        }
    }

    public static void registerFileToDeleteOnDestroy(File f) {
        fileToDeleteOnDestroy.add(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void convertToPdf(URL url, IHtmlToPdfTransformer.PageSize size, List hf, OutputStream out, Map fproperties) throws IHtmlToPdfTransformer.CConvertException {
        Map properties = fproperties != null ? fproperties : new HashMap();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        int priority = Thread.currentThread().getPriority();
        try {
            String tmp;
            Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{}, this.useClassLoader ? CClassLoader.getLoader("/main") : this.getClass().getClassLoader()));
            Thread.currentThread().setPriority(1);
            String uri = url.toExternalForm();
            if (uri.indexOf("://") != -1 && (tmp = uri.substring(uri.indexOf("://") + 3)).indexOf(47) == -1) {
                uri = uri + "/";
            }
            if ((uri = uri.substring(0, uri.lastIndexOf("/") + 1)).startsWith("file:/")) {
                uri = uri.substring(6);
                while (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                uri = "file:///" + uri;
            }
            try {
                IHtmlToPdfTransformer transformer = this.getTransformer(properties);
                transformer.transform(url.openStream(), uri, size, hf, properties, out);
            }
            catch (IHtmlToPdfTransformer.CConvertException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IHtmlToPdfTransformer.CConvertException(e.getMessage(), e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
            Thread.currentThread().setPriority(priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void convertToPdf(String content, IHtmlToPdfTransformer.PageSize size, List hf, String furlForBase, OutputStream out, Map fproperties) throws IHtmlToPdfTransformer.CConvertException {
        Map properties;
        String urlForBase = furlForBase;
        Map map = properties = fproperties != null ? fproperties : new HashMap();
        if (urlForBase != null) {
            String tmp;
            try {
                URL url = new URL(urlForBase);
                if (url == null) {
                    throw new IHtmlToPdfTransformer.CConvertException("urlForBase must be a valid URI.", null);
                }
            }
            catch (Exception e) {
                throw new IHtmlToPdfTransformer.CConvertException("urlForBase must be a valid URI.", null);
            }
            if (urlForBase.indexOf("://") != -1 && (tmp = urlForBase.substring(urlForBase.indexOf("://") + 3)).indexOf(47) == -1) {
                urlForBase = urlForBase + "/";
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        int priority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{}, this.useClassLoader ? CClassLoader.getLoader("/main") : this.getClass().getClassLoader()));
            Thread.currentThread().setPriority(1);
            try {
                IHtmlToPdfTransformer transformer = this.getTransformer(properties);
                transformer.transform(new ByteArrayInputStream(content.getBytes("utf-8")), urlForBase, size, hf, properties, out);
            }
            catch (IHtmlToPdfTransformer.CConvertException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IHtmlToPdfTransformer.CConvertException(e.getMessage(), e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
            Thread.currentThread().setPriority(priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        super.finalize();
        try {
            countMutex.acquire();
            if (--countInstance == 0) {
                CYaHPConverter.destroy();
            }
        }
        finally {
            try {
                countMutex.release();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(boolean useClassLoader) {
        long time;
        block7: {
            final CYaHPConverter converter = this;
            System.out.println("Initializing...");
            time = System.currentTimeMillis();
            if (!useClassLoader) {
                System.out.println("init time: " + (System.currentTimeMillis() - time));
                return;
            }
            if (CClassLoader.getRootLoader().isInit()) {
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        converter.finalize();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            ClassLoader loader = this.getClass().getClassLoader();
            CClassLoaderConfig config = new CClassLoaderConfig();
            config.addLoaderInfo("/main", new CClassLoaderConfig.CLoaderInfo(true, true, false, false));
            config.addFile("/main", loader.getResource("itext-yahp.jar"));
            config.addFile("/main", loader.getResource("tidy-yahp.jar"));
            config.addFile("/main", loader.getResource("log4j-yahp.jar"));
            config.addFile("/main", loader.getResource("shanijar-yahp.jar"));
            config.addFile("/main", loader.getResource("xmlapi-yahp.jar"));
            config.addFile("/main", loader.getResource("yahp-internal.jar"));
            config.addFile("/main", loader.getResource("commonio-yahp.jar"));
            config.addFile("/main", loader.getResource("commonlog-yahp.jar"));
            config.addFile("/main", loader.getResource("core-renderer-yahp.jar"));
            config.addFile("/main", loader.getResource("jaxen-yahp.jar"));
            CClassLoader.init(config);
            try {
                URL url = CClassLoader.getRootLoader().getResource("log4j.properties");
                if (url == null) break block7;
                ClassLoader cx = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(CClassLoader.getRootLoader());
                    Class<?> pc = CClassLoader.getRootLoader().loadClass("org.apache.log4j.PropertyConfigurator");
                    Method configure = pc.getDeclaredMethod("configure", URL.class);
                    configure.invoke(null, url);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cx);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        System.out.println("init time: " + (System.currentTimeMillis() - time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHtmlToPdfTransformer getTransformer(Map properties) {
        try {
            this.mutex.acquire();
            IHtmlToPdfTransformer transformer = null;
            String rendererClassName = "org.allcolor.yahp.cl.converter.CHtmlToPdfFlyingSaucerTransformer";
            if (properties != null && properties.containsKey("yahp.PDF_RENDERER_CLASS")) {
                rendererClassName = (String)properties.get("yahp.PDF_RENDERER_CLASS");
            }
            if (this.transformers.containsKey(rendererClassName)) {
                transformer = (IHtmlToPdfTransformer)this.transformers.get(rendererClassName);
            } else {
                ClassLoader bootStrap = this.useClassLoader ? CClassLoader.getLoader("/main") : this.getClass().getClassLoader();
                try {
                    ClassLoader cx = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.useClassLoader ? CClassLoader.getRootLoader() : this.getClass().getClassLoader());
                        transformer = (IHtmlToPdfTransformer)bootStrap.loadClass(rendererClassName).newInstance();
                        this.transformers.put(rendererClassName, transformer);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(cx);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("SEVERE: Error while getting transformer '" + rendererClassName + "' ! : " + e.getMessage());
                    IHtmlToPdfTransformer iHtmlToPdfTransformer = null;
                    try {
                        this.mutex.release();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return iHtmlToPdfTransformer;
                }
            }
            IHtmlToPdfTransformer iHtmlToPdfTransformer = transformer;
            return iHtmlToPdfTransformer;
        }
        finally {
            try {
                this.mutex.release();
            }
            catch (Exception e) {}
        }
    }

    static {
        try {
            System.setProperty("file.encoding", "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        countMutex = new CMutex();
        countInstance = 0;
        fileToDeleteOnDestroy = new ArrayList();
    }
}

