package playerrors;

import play.*;
import play.exceptions.NoRouteFoundException;
import play.exceptions.PlayException;
import play.libs.WS;
import play.libs.F.Promise;
import play.libs.WS.HttpResponse;
import play.mvc.*;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.*;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class ErrorController extends Controller {

	public static String playErrorsCallback = "http://playerrors.com/callback";
	
	@Util
	@Catch(value = Exception.class)
	public static void catchException(Exception e) {
		
		String apiKey = Play.configuration.getProperty("playerrors.apiKey");
		String callback = Play.configuration.getProperty("playerrors.callback");
		if(callback == null || "".equals(callback)) {
			callback = playErrorsCallback;
		}
		
		if(apiKey == null) {
			Logger.warn("PlayErrors api key error");
			return;
		}
		
		JsonObject response = new JsonObject();
		response.addProperty("apiKey", apiKey);
		response.addProperty("exception", e.getMessage());
		response.addProperty("exceptionClass", e.getClass().getName());
		response.addProperty("stackTrace", getStackTrace(e));
		response.addProperty("params", params.urlEncode());
		
		if(e instanceof PlayException) {
			PlayException pe = (PlayException)e;
			response.addProperty("playErrorTitle", pe.getErrorTitle());
			response.addProperty("playErrorDescription", pe.getErrorDescription());
			if(pe.isSourceAvailable()) {
				response.addProperty("playSourceFile", pe.getSourceFile());
				response.addProperty("playLineNumber", pe.getLineNumber());
			}
			response.addProperty("playId", pe.getId());
		}
		
		Promise <HttpResponse> respPromise = WS.url(callback).
			setParameter("data", response).
			postAsync();
		
		/*
		HttpResponse resp = await(respPromise);
		
		if(!resp.success()) {
			Logger.warn("Error with PlayErrors. Response was: "+resp.getString());
		}
		*/
		
	}
	
	private static String getStackTrace(Throwable throwable) {
		Writer writer = new StringWriter();
		PrintWriter printWriter = new PrintWriter(writer);
		throwable.printStackTrace(printWriter);
		
		return writer.toString();
	}	
	
}

