/*
 * Decompiled with CFR 0.152.
 */
package play.modules.playerrors;

import com.google.gson.JsonObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.exceptions.PlayException;
import play.libs.F;
import play.libs.WS;
import play.mvc.Scope;

public class PlayErrors
extends PlayPlugin {
    public static String playErrorsCallback = "http://playerrors.com/callback";

    public static void reportError(Throwable e) {
        String apiKey = Play.configuration.getProperty("playerrors.apiKey");
        String callback = Play.configuration.getProperty("playerrors.callback");
        if (callback == null || "".equals(callback)) {
            callback = playErrorsCallback;
        }
        if (apiKey == null) {
            Logger.warn((String)"PlayErrors api key error", (Object[])new Object[0]);
            return;
        }
        JsonObject response = new JsonObject();
        response.addProperty("apiKey", apiKey);
        response.addProperty("exception", e.getMessage());
        response.addProperty("exceptionClass", e.getClass().getName());
        response.addProperty("stackTrace", PlayErrors.getStackTrace(e));
        response.addProperty("params", Scope.Params.current().urlEncode());
        response.addProperty("session", Scope.Session.current().toString());
        response.addProperty("flash", Scope.Flash.current().toString());
        response.addProperty("renderArgs", Scope.RenderArgs.current().toString());
        response.addProperty("routeArgs", Scope.RouteArgs.current().toString());
        if (e instanceof PlayException) {
            PlayException pe = (PlayException)e;
            response.addProperty("playErrorTitle", pe.getErrorTitle());
            response.addProperty("playErrorDescription", pe.getErrorDescription());
            if (pe.isSourceAvailable()) {
                response.addProperty("playSourceFile", pe.getSourceFile());
                response.addProperty("playLineNumber", (Number)pe.getLineNumber());
            }
            response.addProperty("playId", pe.getId());
        }
        F.Promise respPromise = WS.url((String)callback).setParameter("data", (Object)response).postAsync();
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }
}

