package play.modules.playerrors;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

import com.google.gson.JsonObject;

import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.exceptions.PlayException;
import play.libs.WS;
import play.libs.F.Promise;
import play.libs.WS.HttpResponse;
import play.mvc.Scope;
import play.mvc.Scope.Params;

public class PlayErrors extends PlayPlugin {
			
	public static String playErrorsCallback = "http://playerrors.com/callback";

	public static void reportError(Throwable e) {
		
		String apiKey = Play.configuration.getProperty("playerrors.apiKey");
		String callback = Play.configuration.getProperty("playerrors.callback");
		if(callback == null || "".equals(callback)) {
			callback = playErrorsCallback;
		}
		
		if(apiKey == null) {
			Logger.warn("PlayErrors api key error");
			return;
		}
		
		JsonObject response = new JsonObject();
		response.addProperty("apiKey", apiKey);
		response.addProperty("exception", e.getMessage());
		response.addProperty("exceptionClass", e.getClass().getName());
		response.addProperty("stackTrace", getStackTrace(e));
		response.addProperty("params", Scope.Params.current().urlEncode());
		response.addProperty("session", Scope.Session.current().toString());
		response.addProperty("flash", Scope.Flash.current().toString());
		response.addProperty("renderArgs", Scope.RenderArgs.current().toString());
		response.addProperty("routeArgs", Scope.RouteArgs.current().toString());

		if(e instanceof PlayException) {
			PlayException pe = (PlayException)e;
			response.addProperty("playErrorTitle", pe.getErrorTitle());
			response.addProperty("playErrorDescription", pe.getErrorDescription());
			if(pe.isSourceAvailable()) {
				response.addProperty("playSourceFile", pe.getSourceFile());
				response.addProperty("playLineNumber", pe.getLineNumber());
			}
			response.addProperty("playId", pe.getId());
		}
		
		//System.out.println(response);
		
		Promise <HttpResponse> respPromise = WS.url(callback).
			setParameter("data", response).
			postAsync();
		
		/*
		HttpResponse resp = await(respPromise);
		
		if(!resp.success()) {
			Logger.warn("Error with PlayErrors. Response was: "+resp.getString());
		}
		*/
	}
	
	private static String getStackTrace(Throwable throwable) {
		Writer writer = new StringWriter();
		PrintWriter printWriter = new PrintWriter(writer);
		throwable.printStackTrace(printWriter);
		
		return writer.toString();
	}	
		
	
	
}
