/*
 * Decompiled with CFR 0.152.
 */
package com.postmark.java;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.postmark.java.DateTimeTypeAdapter;
import com.postmark.java.NameValuePair;
import com.postmark.java.PostmarkException;
import com.postmark.java.PostmarkMessage;
import com.postmark.java.PostmarkResponse;
import com.postmark.java.PostmarkStatus;
import com.postmark.java.SkipMeExclusionStrategy;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostmarkClient {
    private static Logger logger = Logger.getLogger("com.postmark.java");
    private String serverToken;
    private static GsonBuilder gsonBuilder = new GsonBuilder();

    public PostmarkClient(String serverToken) {
        this.serverToken = serverToken;
    }

    public PostmarkResponse sendMessage(String from, String to, String replyTo, String cc, String subject, String body, boolean isHTML, String tag) throws PostmarkException {
        return this.sendMessage(from, to, replyTo, cc, subject, body, isHTML, tag, null);
    }

    public PostmarkResponse sendMessage(String from, String to, String replyTo, String cc, String subject, String body, boolean isHTML, String tag, List<NameValuePair> headers) throws PostmarkException {
        PostmarkMessage message = new PostmarkMessage(from, to, replyTo, subject, cc, body, isHTML, tag, headers);
        return this.sendMessage(message);
    }

    public PostmarkResponse sendMessage(PostmarkMessage message) throws PostmarkException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        PostmarkResponse theResponse = new PostmarkResponse();
        try {
            HttpPost method = new HttpPost("http://api.postmarkapp.com/email");
            method.addHeader("Accept", "application/json");
            method.addHeader("Content-Type", "application/json; charset=utf-8");
            method.addHeader("X-Postmark-Server-Token", this.serverToken);
            method.addHeader("User-Agent", "Postmark-Java");
            message.validate();
            message.clean();
            Gson gson = gsonBuilder.create();
            String messageContents = gson.toJson((Object)message);
            logger.fine("Message contents: " + messageContents);
            StringEntity payload = new StringEntity(messageContents, "UTF-8");
            method.setEntity((HttpEntity)payload);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            try {
                String response = (String)httpClient.execute((HttpUriRequest)method, (ResponseHandler)responseHandler);
                logger.fine("Message response: " + response);
                theResponse = (PostmarkResponse)gsonBuilder.create().fromJson(response, PostmarkResponse.class);
                theResponse.status = PostmarkStatus.SUCCESS;
            }
            catch (HttpResponseException hre) {
                switch (hre.getStatusCode()) {
                    case 401: 
                    case 422: {
                        logger.log(Level.SEVERE, "There was a problem with the email: " + hre.getMessage());
                        theResponse.setMessage(hre.getMessage());
                        theResponse.status = PostmarkStatus.USERERROR;
                        throw new PostmarkException(hre.getMessage(), theResponse);
                    }
                    case 500: {
                        logger.log(Level.SEVERE, "There has been an error sending your email: " + hre.getMessage());
                        theResponse.setMessage(hre.getMessage());
                        theResponse.status = PostmarkStatus.SERVERERROR;
                        throw new PostmarkException(hre.getMessage(), theResponse);
                    }
                }
                logger.log(Level.SEVERE, "There has been an unknow error sending your email: " + hre.getMessage());
                theResponse.status = PostmarkStatus.UNKNOWN;
                theResponse.setMessage(hre.getMessage());
                throw new PostmarkException(hre.getMessage(), theResponse);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "There has been an error sending your email: " + e.getMessage());
            throw new PostmarkException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return theResponse;
    }

    static {
        gsonBuilder.registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeAdapter());
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new SkipMeExclusionStrategy(Boolean.class)});
        logger.addHandler(new ConsoleHandler());
        logger.setLevel(Level.ALL);
    }
}

