/*
 * Decompiled with CFR 0.152.
 */
package press;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import play.Logger;
import play.vfs.VirtualFile;
import press.Compressor;
import press.PluginConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSCompressor
extends Compressor {
    public static final String TAG_NAME = "#{press.script}";
    public static final String FILE_TYPE = "JavaScript";
    public static final String EXTENSION = ".js";
    static Compressor.FileCompressor jsFileCompressor = new Compressor.FileCompressor(){

        public void compress(String fileName, Reader in, Writer out) throws IOException {
            PressErrorReporter errorReporter = new PressErrorReporter(fileName);
            JavaScriptCompressor compressor = new JavaScriptCompressor(in, (ErrorReporter)errorReporter);
            compressor.compress(out, PluginConfig.js.lineBreak, PluginConfig.js.munge, PluginConfig.js.warn, PluginConfig.js.preserveAllSemiColons, PluginConfig.js.preserveStringLiterals);
        }
    };

    public JSCompressor() {
        super(FILE_TYPE, EXTENSION, "press.Press.getCompressedJS", TAG_NAME, "#{press.compressed-script}", "<!-- press-js: ", " -->", PluginConfig.js.srcDir, PluginConfig.js.compressedDir);
    }

    public String compressedSingleFileUrl(String fileName) {
        return this.compressedSingleFileUrl(jsFileCompressor, fileName);
    }

    public static VirtualFile getCompressedFile(String key) {
        return JSCompressor.getCompressedFile(jsFileCompressor, key, PluginConfig.js.compressedDir, EXTENSION);
    }

    public static List<File> clearCache() {
        return JSCompressor.clearCache(PluginConfig.js.compressedDir, EXTENSION);
    }

    static class PressErrorReporter
    implements ErrorReporter {
        private static final String PREFIX = "[YUI Compressor] ";
        private static final String FORMAT_STRING = "%s:%d (char %d) %s";
        String fileName;

        public PressErrorReporter(String fileName) {
            this.fileName = fileName;
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0 || line == 1 && lineOffset == 0) {
                Logger.warn((String)(PREFIX + message), (Object[])new Object[0]);
            } else {
                Logger.warn((String)"[YUI Compressor] %s:%d (char %d) %s", (Object[])new Object[]{this.fileName, line, lineOffset, message});
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0 || line == 1 && lineOffset == 0) {
                Logger.error((String)(PREFIX + message), (Object[])new Object[0]);
            } else {
                Logger.error((String)"[YUI Compressor] %s:%d (char %d) %s", (Object[])new Object[]{this.fileName, line, lineOffset, message});
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

