/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import play.PlayPlugin;
import press.CSSCompressor;
import press.DuplicateFileException;
import press.JSCompressor;
import press.PluginConfig;
import press.PressLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin
extends PlayPlugin {
    static ThreadLocal<JSCompressor> jsCompressor = new ThreadLocal();
    static ThreadLocal<CSSCompressor> cssCompressor = new ThreadLocal();
    static ThreadLocal<Boolean> errorOccurred = new ThreadLocal();
    static ThreadLocal<Map<String, Boolean>> jsFiles = new ThreadLocal();
    static ThreadLocal<Map<String, Boolean>> cssFiles = new ThreadLocal();

    public void onApplicationStart() {
        PluginConfig.readConfig();
        JSCompressor.clearCache();
        CSSCompressor.clearCache();
    }

    public void beforeActionInvocation(Method actionMethod) {
        jsCompressor.set(new JSCompressor());
        cssCompressor.set(new CSSCompressor());
        errorOccurred.set(false);
        jsFiles.set(new HashMap());
        cssFiles.set(new HashMap());
    }

    public static String compressedSingleJSUrl(String fileName) {
        return jsCompressor.get().compressedSingleFileUrl(fileName);
    }

    public static String compressedSingleCSSUrl(String fileName) {
        return cssCompressor.get().compressedSingleFileUrl(fileName);
    }

    public static boolean outputJSTag(String fileName, boolean compress, boolean ignoreDuplicates) {
        return Plugin.outputTag(jsFiles.get(), fileName, compress, ignoreDuplicates, "JavaScript", "#{press.script}");
    }

    public static boolean outputCSSTag(String fileName, boolean compress, boolean ignoreDuplicates) {
        return Plugin.outputTag(cssFiles.get(), fileName, compress, ignoreDuplicates, "CSS", "#{press.stylesheet}");
    }

    private static boolean outputTag(Map<String, Boolean> files, String fileName, boolean compress, boolean ignoreDuplicates, String fileType, String tagName) {
        if (!files.containsKey(fileName)) {
            files.put(fileName, true);
            return true;
        }
        if (ignoreDuplicates) {
            PressLogger.trace("Ignoring duplicate file %s", fileName);
            return false;
        }
        throw new DuplicateFileException(fileType, fileName, tagName);
    }

    public static String addJS(String fileName, boolean compress, boolean ignoreDuplicates) {
        return jsCompressor.get().add(fileName, compress, ignoreDuplicates);
    }

    public static String addCSS(String fileName, boolean compress, boolean ignoreDuplicates) {
        return cssCompressor.get().add(fileName, compress, ignoreDuplicates);
    }

    public static String compressedJSUrl() {
        return jsCompressor.get().compressedUrl();
    }

    public static String compressedCSSUrl() {
        return cssCompressor.get().compressedUrl();
    }

    public void afterActionInvocation() {
        if (jsCompressor.get() != null && cssCompressor.get() != null) {
            jsCompressor.get().saveFileList();
            cssCompressor.get().saveFileList();
        }
    }

    public void onInvocationException(Throwable e) {
        errorOccurred.set(true);
    }

    public static boolean hasErrorOccurred() {
        return errorOccurred.get() == null || errorOccurred.get() != false;
    }

    public static boolean enabled() {
        return PluginConfig.enabled;
    }

    public static boolean performCompression() {
        return Plugin.enabled() && !Plugin.hasErrorOccurred();
    }
}

