/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.exceptions.UnexpectedException;
import play.libs.Crypto;
import play.mvc.Http;
import play.mvc.Router;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;
import press.CachingStrategy;
import press.DuplicateFileException;
import press.PluginConfig;
import press.PressException;
import press.PressFileFilter;
import press.PressLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Compressor
extends PlayPlugin {
    static final String PRESS_SIGNATURE = "press-1.0";
    static final String PATTERN_TEXT = "^/\\*press-1.0\\|(.*?)\\*/$";
    static final Pattern HEADER_PATTERN = Pattern.compile("^/\\*press-1.0\\|(.*?)\\*/$");
    String fileType;
    String extension;
    String getCompressedFileAction;
    String tagName;
    String compressedTagName;
    String pressRequestStart;
    String pressRequestEnd;
    String srcDir;
    String compressedDir;
    String requestKey = null;
    Http.Response currentResponse;
    Map<String, List<FileInfo>> fileInfos = new HashMap<String, List<FileInfo>>();

    public Compressor(String fileType, String extension, String getCompressedFileAction, String tagName, String compressedTagName, String pressRequestStart, String pressRequestEnd, String srcDir, String compressedDir) {
        this.currentResponse = Http.Response.current();
        this.fileType = fileType;
        this.extension = extension;
        this.getCompressedFileAction = getCompressedFileAction;
        this.pressRequestStart = pressRequestStart;
        this.pressRequestEnd = pressRequestEnd;
        this.tagName = tagName;
        this.compressedTagName = compressedTagName;
        this.srcDir = PluginConfig.addTrailingSlash(srcDir);
        this.compressedDir = PluginConfig.addTrailingSlash(compressedDir);
    }

    public String add(String fileName, boolean compress) {
        if (compress) {
            PressLogger.trace("Adding %s to output", fileName);
        } else {
            PressLogger.trace("Adding uncompressed file %s to output", fileName);
        }
        if (this.fileInfos.containsKey(fileName)) {
            throw new DuplicateFileException(this.fileType, fileName, this.tagName);
        }
        this.checkFileExists(fileName);
        List<FileInfo> fileInfoList = this.fileInfos.get(fileName);
        if (fileInfoList == null) {
            fileInfoList = new ArrayList<FileInfo>();
            this.fileInfos.put(fileName, fileInfoList);
        }
        fileInfoList.add(new FileInfo(fileName, compress, null));
        return this.getFileRequestSignature(this.getFileNameWithIndex(fileName, fileInfoList.size() - 1));
    }

    public String compressedSingleFileUrl(FileCompressor compressor, String fileName) {
        PressLogger.trace("Request to compress single file %s", fileName);
        int lastDot = fileName.lastIndexOf(46);
        String compressedFileName = fileName.substring(0, lastDot) + ".min";
        compressedFileName = compressedFileName + fileName.substring(lastDot);
        VirtualFile srcFile = this.checkFileExists(fileName);
        ArrayList<FileInfo> componentFiles = new ArrayList<FileInfo>(1);
        componentFiles.add(new FileInfo(compressedFileName, true, srcFile));
        String outputFilePath = this.compressedDir + compressedFileName;
        VirtualFile outputFile = Compressor.getVirtualFile(outputFilePath);
        if (Compressor.useCache(componentFiles, outputFile, this.extension) && outputFile.exists()) {
            PressLogger.trace("File has already been compressed", new Object[0]);
        } else {
            Compressor.writeCompressedFile(compressor, componentFiles, outputFile, null);
        }
        return outputFilePath;
    }

    public String compressedUrl() {
        if (this.requestKey != null) {
            String msg = "There is more than one " + this.compressedTagName + " tag in the template output. " + "There must be one only.";
            throw new PressException(msg);
        }
        this.requestKey = this.getRequestKey() + this.extension;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", this.requestKey);
        Router.ActionDefinition route = Router.reverse((String)this.getCompressedFileAction, params);
        int numFiles = this.getTotalFileCount();
        PressLogger.trace("Adding key %s for compression of %d files", this.requestKey, numFiles);
        return route.url;
    }

    public void saveFileList() {
        if (this.requestKey == null) {
            if (this.fileInfos.size() > 0) {
                String msg = this.getTotalFileCount() + " files added to compression with ";
                msg = msg + this.tagName + " tag but no " + this.compressedTagName + " tag was found. ";
                msg = msg + "You must include a " + this.compressedTagName + " tag in the template ";
                msg = msg + "to output the compressed content of these files: ";
                msg = msg + JavaExtensions.join(this.fileInfos.keySet(), (String)", ");
                throw new PressException(msg);
            }
            return;
        }
        long timeStart = System.currentTimeMillis();
        List<FileInfo> orderedFileNames = this.getFileListOrder();
        long timeAfter = System.currentTimeMillis();
        PressLogger.trace("Time to scan response for %s files for '%s': %d milli-seconds", this.fileType, Http.Request.current().url, timeAfter - timeStart);
        this.addFileListToCache(this.requestKey, orderedFileNames);
    }

    public List<FileInfo> getFileListOrder() {
        String content = this.getResponseContent();
        List<String> namesInOrder = this.getFilesInResponse(content);
        ArrayList<FileInfo> filesInOrder = new ArrayList<FileInfo>(namesInOrder.size());
        if (namesInOrder.size() != this.getTotalFileCount()) {
            String msg = "Number of file compress requests found in response ";
            msg = msg + "(" + namesInOrder.size() + ") ";
            msg = msg + "not equal to number of files added to compression ";
            msg = msg + "(" + this.fileInfos.size() + "). ";
            msg = msg + "Please report a bug.\n";
            msg = msg + "Note: Do not use press tags within a 404.html or 500.html ";
            msg = msg + "template, it will not work.";
            throw new PressException(msg);
        }
        for (String fileNameWithIndex : namesInOrder) {
            String fileName = this.getFileName(fileNameWithIndex);
            int fileIndex = this.getFileIndex(fileNameWithIndex);
            if (!this.fileInfos.containsKey(fileName)) {
                String msg = "File compress request for '" + fileName + "' ";
                msg = msg + "found in response but file was never added to file list. ";
                msg = msg + "Please report a bug.";
                throw new PressException(msg);
            }
            filesInOrder.add(this.fileInfos.get(fileName).get(fileIndex));
        }
        return filesInOrder;
    }

    public void addFileListToCache(String cacheKey, List<FileInfo> originalList) {
        ArrayList<FileInfo> newList = new ArrayList<FileInfo>();
        for (FileInfo fileInfo : originalList) {
            VirtualFile file = Compressor.getVirtualFile(this.srcDir + fileInfo.fileName);
            if (!file.exists()) {
                String msg = "Attempt to add file '" + file.getRealFile().getAbsolutePath() + "' ";
                msg = msg + "to compression with " + this.tagName + " tag but file does not exist.";
                throw new PressException(msg);
            }
            newList.add(new FileInfo(fileInfo.fileName, fileInfo.compress, file));
        }
        Cache.set((String)cacheKey, newList, (String)PluginConfig.compressionKeyStorageTime);
    }

    private String getRequestKey() {
        String key = Http.Request.current().path + Http.Request.current().querystring + this.extension;
        String hashed = Crypto.passwordHash((String)key);
        return Compressor.lettersOnly(hashed);
    }

    protected static VirtualFile getCompressedFile(FileCompressor compressor, String key, String compressedDir, String extension) {
        List componentFiles = (List)Cache.get((String)key);
        if (componentFiles == null) {
            return null;
        }
        return Compressor.getCompressedFile(compressor, componentFiles, compressedDir, extension);
    }

    protected static VirtualFile getCompressedFile(FileCompressor compressor, List<FileInfo> componentFiles, String compressedDir, String extension) {
        String joinedFileNames = JavaExtensions.join(FileInfo.getFileNames(componentFiles), (String)"");
        String fileName = Crypto.passwordHash((String)joinedFileNames);
        fileName = Compressor.lettersOnly(fileName);
        String filePath = compressedDir + fileName + extension;
        VirtualFile file = Compressor.getVirtualFile(filePath);
        if (Compressor.useCache(componentFiles, file, extension)) {
            String absolutePath = file.getRealFile().getAbsolutePath();
            if (file.exists()) {
                PressLogger.trace("Using existing compressed file %s", absolutePath);
                return file;
            }
            PressLogger.trace("Compressed file %s does not yet exist", absolutePath);
        }
        PressLogger.trace("Generating compressed file %s from %d component files", file.getName(), componentFiles.size());
        File tmp = Compressor.getTmpOutputFile(file);
        if (tmp == null) {
            PressLogger.trace("Compressed file was generated by another thread", new Object[0]);
        } else {
            Compressor.writeCompressedFile(compressor, componentFiles, file, tmp);
        }
        return file;
    }

    private static void writeCompressedFile(FileCompressor compressor, List<FileInfo> componentFiles, VirtualFile file, File tmp) {
        VirtualFile dir = VirtualFile.open((String)file.getRealFile().getParent());
        if (!dir.exists() && !dir.getRealFile().mkdirs()) {
            throw new PressException("Could not create directory for compressed file output " + file.getRealFile().getAbsolutePath());
        }
        Writer out = null;
        try {
            File destFile = tmp != null ? tmp : file.getRealFile();
            out = new BufferedWriter(new FileWriter(destFile));
            String lastModifiedDates = Compressor.createFileHeader(componentFiles);
            out.append(lastModifiedDates);
            long timeStart = System.currentTimeMillis();
            for (FileInfo componentFile : componentFiles) {
                Compressor.compress(compressor, componentFile, out);
            }
            out.flush();
            out.close();
            long timeAfter = System.currentTimeMillis();
            PressLogger.trace("Time to compress files for '%s': %d milli-seconds", file.getRealFile().getName(), timeAfter - timeStart);
            if (tmp != null) {
                String msg = "Output written to temporary file\n%s\n";
                msg = msg + "Moving from tmp path to final path:\n%s";
                String tmpPath = tmp.getAbsolutePath();
                String finalPath = file.getRealFile().getAbsolutePath();
                PressLogger.trace(msg, tmpPath, finalPath);
                if (!tmp.renameTo(file.getRealFile())) {
                    String ex = "Successfully wrote compressed file to temporary path\n" + tmpPath;
                    ex = ex + "\nBut could not move it to final path\n" + finalPath;
                    throw new PressException(ex);
                }
            }
            PressLogger.trace("Compressed file generation complete:", new Object[0]);
            PressLogger.trace(file.relativePath(), new Object[0]);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new UnexpectedException((Throwable)e);
                }
            }
        }
    }

    private static File getTmpOutputFile(VirtualFile file) {
        String origPath = file.getRealFile().getAbsolutePath();
        File tmp = new File(origPath + ".tmp");
        if (tmp.exists()) {
            long tmpLastModified = tmp.lastModified();
            long now = System.currentTimeMillis();
            if (tmpLastModified < file.lastModified()) {
                return tmp;
            }
            if (now - tmpLastModified > (long)PluginConfig.maxCompressionTimeMillis) {
                return tmp;
            }
            while (tmp.exists()) {
                if (System.currentTimeMillis() - now > (long)PluginConfig.maxCompressionTimeMillis) {
                    throw new PressException("Timeout waiting for compressed file to be generated");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            return null;
        }
        return tmp;
    }

    public static List<File> clearCache(String compressedDir, String extension) {
        PressLogger.trace("Deleting cached files", new Object[0]);
        VirtualFile dir = Compressor.getVirtualFile(compressedDir);
        if (!dir.exists() || !dir.isDirectory()) {
            return new ArrayList<File>();
        }
        PressFileFilter compressedFileFilter = new PressFileFilter(extension);
        File[] files = dir.getRealFile().listFiles(compressedFileFilter);
        ArrayList<File> deleted = new ArrayList<File>(files.length);
        for (File file : files) {
            if (!file.delete()) continue;
            deleted.add(file);
        }
        PressLogger.trace("Deleted %d cached files", deleted.size());
        return deleted;
    }

    private static boolean useCache(List<FileInfo> componentFiles, VirtualFile file, String extension) {
        PressLogger.trace("Caching strategy is %s", new Object[]{PluginConfig.cache});
        if (PluginConfig.cache.equals((Object)CachingStrategy.Never)) {
            return false;
        }
        if (PluginConfig.cache.equals((Object)CachingStrategy.Always)) {
            return true;
        }
        boolean changed = Compressor.haveComponentFilesChanged(componentFiles, file);
        if (changed) {
            PressLogger.trace("Component %s files have changed", extension);
        } else {
            PressLogger.trace("Component %s files have not changed", extension);
        }
        return !changed;
    }

    private static boolean haveComponentFilesChanged(List<FileInfo> componentFiles, VirtualFile file) {
        if (!file.exists()) {
            return true;
        }
        String header = Compressor.extractHeaderContent(file.getRealFile());
        if (header == null) {
            return true;
        }
        String[] lastModifieds = header.split(":");
        if (lastModifieds.length != componentFiles.size()) {
            return true;
        }
        try {
            for (int i = 0; i < componentFiles.size(); ++i) {
                char compress;
                FileInfo fileInfo = componentFiles.get(i);
                char c = compress = fileInfo.compress ? (char)'c' : 'u';
                if (lastModifieds[i].charAt(0) != compress) {
                    return true;
                }
                String lastMod = lastModifieds[i].substring(1);
                long lastModified = Long.parseLong(lastMod);
                if (fileInfo.file.lastModified() == lastModified) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static String createFileHeader(List<FileInfo> componentFiles) {
        ArrayList<String> timestamps = new ArrayList<String>(componentFiles.size());
        for (int i = 0; i < componentFiles.size(); ++i) {
            FileInfo fileInfo = componentFiles.get(i);
            String lastMod = fileInfo.file.lastModified().toString();
            char compress = fileInfo.compress ? (char)'c' : 'u';
            timestamps.add(compress + lastMod);
        }
        return "/*press-1.0|" + JavaExtensions.join(timestamps, (String)":") + "*/\n";
    }

    public static String extractHeaderContent(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String firstLine = reader.readLine();
            Matcher matcher = HEADER_PATTERN.matcher(firstLine);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private static void compress(FileCompressor compressor, FileInfo fileInfo, Writer out) throws Exception {
        String fileName = fileInfo.file.getName();
        BufferedReader in = new BufferedReader(new FileReader(fileInfo.file.getRealFile()));
        if (fileInfo.compress) {
            PressLogger.trace("Compressing %s", fileName);
            compressor.compress(fileName, in, out);
        } else {
            PressLogger.trace("Adding already compressed file %s", fileName);
            Compressor.write(in, out);
            compressor.compress(fileName, in, out);
        }
    }

    public static void write(Reader reader, Writer writer) throws IOException {
        int read = 0;
        char[] buffer = new char[8096];
        while ((read = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, read);
        }
    }

    private static String lettersOnly(String hashed) {
        char[] chars = hashed.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i])) continue;
            chars[i] = (char)(65 + chars[i] % 26);
        }
        return new String(chars);
    }

    protected String getResponseContent() {
        try {
            return this.currentResponse.out.toString("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected String getFileRequestSignature(String fileName) {
        return this.pressRequestStart + fileName + this.pressRequestEnd;
    }

    protected List<String> getFilesInResponse(String content) {
        ArrayList<String> filesInOrder = new ArrayList<String>();
        int startIndex = content.indexOf(this.pressRequestStart);
        while (startIndex != -1) {
            int endIndex = content.indexOf(this.pressRequestEnd, startIndex);
            if (endIndex == -1) {
                return filesInOrder;
            }
            int fileNameStartIndex = startIndex + this.pressRequestStart.length();
            String foundFileName = content.substring(fileNameStartIndex, endIndex);
            filesInOrder.add(foundFileName);
            startIndex = content.indexOf(this.pressRequestStart, endIndex);
        }
        return filesInOrder;
    }

    private String getFileNameWithIndex(String fileName, int index) {
        return fileName + "[" + index + "]";
    }

    private String getFileName(String fileNameWithIndex) {
        int indexPart = fileNameWithIndex.lastIndexOf(91);
        return fileNameWithIndex.substring(0, indexPart);
    }

    private int getFileIndex(String fileNameWithIndex) {
        int indexPartBegin = fileNameWithIndex.lastIndexOf(91);
        String indexPart = fileNameWithIndex.substring(indexPartBegin + 1, fileNameWithIndex.length() - 1);
        return Integer.parseInt(indexPart);
    }

    private int getTotalFileCount() {
        int i = 0;
        for (String fileName : this.fileInfos.keySet()) {
            i += this.fileInfos.get(fileName).size();
        }
        return i;
    }

    public VirtualFile checkFileExists(String fileName) {
        return Compressor.checkFileExists(fileName, this.srcDir);
    }

    public static VirtualFile checkFileExists(String fileName, String sourceDirectory) {
        VirtualFile srcFile = Compressor.getVirtualFile(sourceDirectory + fileName);
        if (!srcFile.exists()) {
            String msg = "Attempt to add file '" + srcFile.getRealFile().getAbsolutePath() + "' ";
            msg = msg + "to compression but file does not exist.";
            throw new PressException(msg);
        }
        return srcFile;
    }

    private static VirtualFile getVirtualFile(String filePath) {
        VirtualFile vf = Play.getVirtualFile((String)filePath);
        if (vf == null) {
            return VirtualFile.open((File)Play.getFile((String)filePath));
        }
        return vf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FileInfo {
        String fileName;
        boolean compress;
        private VirtualFile file;

        public FileInfo(String fileName, boolean compress, VirtualFile file) {
            this.fileName = fileName;
            this.compress = compress;
            this.file = file;
        }

        public static Collection<String> getFileNames(List<FileInfo> list) {
            ArrayList<String> fileNames = new ArrayList<String>(list.size());
            for (FileInfo fileInfo : list) {
                fileNames.add(fileInfo.fileName);
            }
            return fileNames;
        }
    }

    protected static interface FileCompressor {
        public void compress(String var1, Reader var2, Writer var3) throws Exception;
    }
}

