/*
 * Decompiled with CFR 0.152.
 */
package press.io;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import play.cache.Cache;
import play.exceptions.UnexpectedException;
import press.PluginConfig;
import press.PressException;
import press.PressLogger;
import press.io.CompressedFile;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCompressedFile
extends CompressedFile {
    private static final String FILE_LIST_KEY = "InMemoryFileList";
    private InputStream inputStream;
    private Writer writer;
    private ByteArrayOutputStream outputStream;
    private byte[] bytes;
    private static final String A_VERY_LONG_TIME = "3650d";

    public InMemoryCompressedFile(String filePath) {
        super(filePath);
    }

    @Override
    public boolean exists() {
        if (this.inputStream != null) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        this.bytes = (byte[])Cache.get((String)this.getCacheKey());
        if (this.bytes != null) {
            long totalTime = System.currentTimeMillis() - startTime;
            PressLogger.trace("Got file of size %d bytes from cache in %d milli-seconds.", this.bytes.length, totalTime);
            this.inputStream = new ByteArrayInputStream(this.bytes);
            return true;
        }
        return false;
    }

    @Override
    public InputStream inputStream() {
        if (!this.exists()) {
            throw new PressException("Can't create InputStream. File with key " + this.getCacheKey() + " does not exist in cache");
        }
        return this.inputStream;
    }

    @Override
    public String name() {
        return FileIO.getFileNameFromPath(this.getFilePath());
    }

    @Override
    public Writer startWrite() {
        String inProgressKey = InMemoryCompressedFile.getInProgressKey(this.getFilePath());
        if (Cache.get((String)inProgressKey) != null) {
            return null;
        }
        String expiration = PluginConfig.maxCompressionTimeMillis / 1000 + "s";
        Cache.safeSet((String)inProgressKey, (Object)true, (String)expiration);
        if (this.writer == null) {
            this.outputStream = new ByteArrayOutputStream();
            this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
        }
        return this.writer;
    }

    @Override
    public void close() {
        if (this.writer == null) {
            throw new PressException("Output stream has not yet been created. Call getWriter() and write to it.");
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
        byte[] outBytes = this.outputStream.toByteArray();
        PressLogger.trace("Saving file of size %d bytes to cache.", outBytes.length);
        this.addFileToCache(this.getFilePath(), outBytes);
    }

    private static String getInProgressKey(String filePath) {
        return "in-progress-" + filePath;
    }

    private String getCacheKey() {
        return InMemoryCompressedFile.getCacheKey(this.getFilePath());
    }

    private static String getCacheKey(String filePath) {
        return "file-" + filePath;
    }

    private void addFileToCache(String filePath, byte[] outBytes) {
        long startTime = System.currentTimeMillis();
        List<String> fileList = InMemoryCompressedFile.getFileList();
        fileList.add(filePath);
        Cache.set((String)FILE_LIST_KEY, fileList, (String)A_VERY_LONG_TIME);
        String cacheKey = InMemoryCompressedFile.getCacheKey(filePath);
        if (!Cache.safeSet((String)cacheKey, (Object)outBytes, (String)A_VERY_LONG_TIME)) {
            throw new PressException("Underlying cache implementation could not store compressed file " + filePath + " in cache");
        }
        long totalTime = System.currentTimeMillis() - startTime;
        PressLogger.trace("Saved file to cache in %d milli-seconds", totalTime);
    }

    public static int clearMemoryCache(String extension) {
        List<String> files = InMemoryCompressedFile.getFileList();
        for (String filePath : files) {
            Cache.delete((String)InMemoryCompressedFile.getCacheKey(filePath));
            Cache.delete((String)InMemoryCompressedFile.getInProgressKey(filePath));
        }
        Cache.delete((String)FILE_LIST_KEY);
        return files.size();
    }

    private static List<String> getFileList() {
        ArrayList fileList = (ArrayList)Cache.get((String)FILE_LIST_KEY);
        if (fileList == null) {
            fileList = new ArrayList();
        }
        return fileList;
    }

    @Override
    public long length() {
        if (!this.exists()) {
            throw new PressException("Can't get length. File with key " + this.getCacheKey() + " does not exist in cache");
        }
        return this.bytes.length;
    }
}

