/*
 * Decompiled with CFR 0.152.
 */
package controllers.press;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.exceptions.UnexpectedException;
import play.mvc.Controller;
import press.CSSCompressor;
import press.CachingStrategy;
import press.JSCompressor;
import press.PluginConfig;
import press.io.CompressedFile;
import press.io.FileIO;

public class Press
extends Controller {
    public static final DateTimeFormatter httpDateTimeFormatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'");

    public static void getCompressedJS(String key) {
        key = FileIO.unescape(key);
        CompressedFile compressedFile = JSCompressor.getCompressedFile(key);
        Press.renderCompressedFile(compressedFile, "JavaScript");
    }

    public static void getCompressedCSS(String key) {
        key = FileIO.unescape(key);
        CompressedFile compressedFile = CSSCompressor.getCompressedFile(key);
        Press.renderCompressedFile(compressedFile, "CSS");
    }

    public static void getSingleCompressedJS(String key) {
        key = FileIO.unescape(key);
        CompressedFile compressedFile = JSCompressor.getSingleCompressedFile(key);
        Press.renderCompressedFile(compressedFile, "JavaScript");
    }

    public static void getSingleCompressedCSS(String key) {
        key = FileIO.unescape(key);
        CompressedFile compressedFile = CSSCompressor.getSingleCompressedFile(key);
        Press.renderCompressedFile(compressedFile, "CSS");
    }

    private static void renderCompressedFile(CompressedFile compressedFile, String type) {
        if (compressedFile == null) {
            Press.renderBadResponse(type);
        }
        InputStream inputStream = compressedFile.inputStream();
        try {
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
        if (PluginConfig.cache.equals((Object)CachingStrategy.Change)) {
            response.setHeader("Cache-Control", "max-age=31536000");
            response.setHeader("Expires", httpDateTimeFormatter.print((ReadableInstant)new DateTime().plusYears(1)));
        }
        Press.renderBinary((InputStream)inputStream, (String)compressedFile.name());
    }

    public static void clearJSCache() {
        if (!PluginConfig.cacheClearEnabled) {
            Press.forbidden();
        }
        int count = JSCompressor.clearCache();
        Press.renderText((Object)("Cleared " + count + " JS files from cache"));
    }

    public static void clearCSSCache() {
        if (!PluginConfig.cacheClearEnabled) {
            Press.forbidden();
        }
        int count = CSSCompressor.clearCache();
        Press.renderText((Object)("Cleared " + count + " CSS files from cache"));
    }

    private static void renderBadResponse(String fileType) {
        String response = "/*\n";
        response = response + "The compressed " + fileType + " file could not be generated.\n";
        response = response + "This can occur in two situations:\n";
        response = response + "1. The time between when the page was rendered by the ";
        response = response + "server and when the browser requested the compressed ";
        response = response + "file was greater than the timeout. (The timeout is ";
        response = response + "currently configured to be ";
        response = response + PluginConfig.compressionKeyStorageTime + ")\n";
        response = response + "2. There was an exception thrown while rendering the ";
        response = response + "page.\n";
        response = response + "*/";
        Press.renderBinaryResponse(response);
    }

    private static void renderBinaryResponse(String response) {
        try {
            Press.renderBinary((InputStream)new ByteArrayInputStream(response.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

