/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import play.PlayPlugin;
import play.mvc.Router;
import press.CSSCompressor;
import press.DuplicateFileException;
import press.JSCompressor;
import press.PluginConfig;
import press.io.FileIO;
import press.io.PressFileGlobber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin
extends PlayPlugin {
    static ThreadLocal<JSCompressor> jsCompressor = new ThreadLocal();
    static ThreadLocal<CSSCompressor> cssCompressor = new ThreadLocal();
    static ThreadLocal<Boolean> errorOccurred = new ThreadLocal();
    static ThreadLocal<Map<String, Boolean>> jsFiles = new ThreadLocal();
    static ThreadLocal<Map<String, Boolean>> cssFiles = new ThreadLocal();

    public void onApplicationStart() {
        PluginConfig.readConfig();
        JSCompressor.clearCache();
        CSSCompressor.clearCache();
    }

    public void beforeActionInvocation(Method actionMethod) {
        jsCompressor.set(new JSCompressor());
        cssCompressor.set(new CSSCompressor());
        errorOccurred.set(false);
        jsFiles.set(new HashMap());
        cssFiles.set(new HashMap());
    }

    public static String addSingleJS(String fileName) {
        Plugin.checkJSFileExists(fileName);
        JSCompressor compressor = jsCompressor.get();
        String src = null;
        if (Plugin.performCompression()) {
            String requestKey = compressor.compressedSingleFileUrl(fileName);
            src = PluginConfig.isInMemoryStorage() ? Plugin.getSingleCompressedJSUrl(requestKey) : requestKey;
        } else {
            src = compressor.srcDir + fileName;
        }
        return Plugin.getScriptTag(src);
    }

    public static String addSingleCSS(String fileName) {
        Plugin.checkCSSFileExists(fileName);
        CSSCompressor compressor = cssCompressor.get();
        String src = null;
        if (Plugin.performCompression()) {
            String requestKey = compressor.compressedSingleFileUrl(fileName);
            src = PluginConfig.isInMemoryStorage() ? Plugin.getSingleCompressedCSSUrl(requestKey) : requestKey;
        } else {
            src = compressor.srcDir + fileName;
        }
        return Plugin.getLinkTag(src);
    }

    public static String addJS(String src, boolean compress) {
        JSCompressor compressor = jsCompressor.get();
        String baseUrl = compressor.srcDir;
        String result = "";
        for (String fileName : PressFileGlobber.getResolvedFiles(src, baseUrl)) {
            Plugin.checkForJSDuplicates(fileName);
            if (Plugin.performCompression()) {
                result = result + compressor.add(fileName, compress) + "\n";
                continue;
            }
            result = result + Plugin.getScriptTag(baseUrl + fileName);
        }
        return result;
    }

    public static String addCSS(String src, boolean compress) {
        CSSCompressor compressor = cssCompressor.get();
        String baseUrl = compressor.srcDir;
        String result = "";
        for (String fileName : PressFileGlobber.getResolvedFiles(src, baseUrl)) {
            Plugin.checkForCSSDuplicates(fileName);
            if (Plugin.performCompression()) {
                result = result + compressor.add(fileName, compress) + "\n";
                continue;
            }
            result = result + Plugin.getLinkTag(baseUrl + fileName);
        }
        return result;
    }

    public static String compressedCSSTag() {
        if (Plugin.performCompression()) {
            String requestKey = cssCompressor.get().closeRequest();
            return Plugin.getLinkTag(Plugin.getCompressedCSSUrl(requestKey));
        }
        return "";
    }

    public static String compressedJSTag() {
        if (Plugin.performCompression()) {
            String requestKey = jsCompressor.get().closeRequest();
            return Plugin.getScriptTag(Plugin.getCompressedJSUrl(requestKey));
        }
        return "";
    }

    public void afterActionInvocation() {
        if (jsCompressor.get() != null && cssCompressor.get() != null && Plugin.performCompression()) {
            jsCompressor.get().saveFileList();
            cssCompressor.get().saveFileList();
        }
    }

    public void onInvocationException(Throwable e) {
        errorOccurred.set(true);
    }

    public static boolean hasErrorOccurred() {
        return errorOccurred.get() == null || errorOccurred.get() != false;
    }

    public static boolean performCompression() {
        return PluginConfig.enabled && !Plugin.hasErrorOccurred();
    }

    public static void checkJSFileExists(String fileName) {
        JSCompressor.checkJSFileExists(fileName);
    }

    public static void checkCSSFileExists(String fileName) {
        CSSCompressor.checkCSSFileExists(fileName);
    }

    public static void checkForJSDuplicates(String fileName) {
        Plugin.checkJSFileExists(fileName);
        Plugin.checkForDuplicates(jsFiles.get(), fileName, "JavaScript", "#{press.script}");
    }

    public static void checkForCSSDuplicates(String fileName) {
        Plugin.checkCSSFileExists(fileName);
        Plugin.checkForDuplicates(cssFiles.get(), fileName, "CSS", "#{press.stylesheet}");
    }

    private static void checkForDuplicates(Map<String, Boolean> files, String fileName, String fileType, String tagName) {
        if (!files.containsKey(fileName)) {
            files.put(fileName, true);
            return;
        }
        throw new DuplicateFileException(fileType, fileName, tagName);
    }

    private static String getSingleCompressedCSSUrl(String requestKey) {
        return Plugin.getCompressedUrl("press.Press.getSingleCompressedCSS", requestKey);
    }

    private static String getSingleCompressedJSUrl(String requestKey) {
        return Plugin.getCompressedUrl("press.Press.getSingleCompressedJS", requestKey);
    }

    private static String getCompressedCSSUrl(String requestKey) {
        return Plugin.getCompressedUrl("press.Press.getCompressedCSS", requestKey);
    }

    private static String getCompressedJSUrl(String requestKey) {
        return Plugin.getCompressedUrl("press.Press.getCompressedJS", requestKey);
    }

    private static String getCompressedUrl(String action, String requestKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", FileIO.escape(requestKey));
        return Router.reverse((String)action, params).url;
    }

    private static String getScriptTag(String src) {
        return "<script src=\"" + PluginConfig.contentHostingDomain + src + "\" type=\"text/javascript\" language=\"javascript\" charset=\"utf-8\">" + "</script>\n";
    }

    private static String getLinkTag(String src) {
        return "<link href=\"" + PluginConfig.contentHostingDomain + src + "\" rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\">" + (PluginConfig.htmlCompatible ? "" : "</link>") + "\n";
    }
}

