/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.PlayPlugin;
import play.cache.Cache;
import play.exceptions.UnexpectedException;
import play.libs.Crypto;
import play.mvc.Http;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;
import press.CachingStrategy;
import press.DuplicateFileException;
import press.PluginConfig;
import press.PressException;
import press.PressLogger;
import press.io.CompressedFile;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Compressor
extends PlayPlugin {
    static final String PRESS_SIGNATURE = "press-1.0";
    static final String PATTERN_TEXT = "^/\\*press-1.0\\*/$";
    static final Pattern HEADER_PATTERN = Pattern.compile("^/\\*press-1.0\\*/$");
    String fileType;
    String extension;
    String tagName;
    String compressedTagName;
    String pressRequestStart;
    String pressRequestEnd;
    String srcDir;
    String compressedDir;
    String requestKey = null;
    Http.Response currentResponse;
    Map<String, FileInfo> fileInfos = new HashMap<String, FileInfo>();

    public Compressor(String fileType, String extension, String tagName, String compressedTagName, String pressRequestStart, String pressRequestEnd, String srcDir, String compressedDir) {
        this.currentResponse = Http.Response.current();
        this.fileType = fileType;
        this.extension = extension;
        this.pressRequestStart = pressRequestStart;
        this.pressRequestEnd = pressRequestEnd;
        this.tagName = tagName;
        this.compressedTagName = compressedTagName;
        this.srcDir = PluginConfig.addTrailingSlash(srcDir);
        this.compressedDir = PluginConfig.addTrailingSlash(compressedDir);
    }

    public String compressedSingleFileUrl(FileCompressor compressor, String fileName) {
        PressLogger.trace("Request to compress single file %s", fileName);
        int lastDot = fileName.lastIndexOf(46);
        String compressedFileName = fileName.substring(0, lastDot) + ".min";
        compressedFileName = compressedFileName + fileName.substring(lastDot);
        VirtualFile srcFile = this.checkFileExists(fileName);
        ArrayList<FileInfo> componentFiles = new ArrayList<FileInfo>(1);
        componentFiles.add(new FileInfo(compressedFileName, true, srcFile));
        String outputFilePath = this.compressedDir + compressedFileName;
        CompressedFile outputFile = CompressedFile.create(outputFilePath);
        if (outputFile.exists() && Compressor.useCache(componentFiles, outputFile, this.extension)) {
            PressLogger.trace("File has already been compressed", new Object[0]);
        } else {
            Compressor.writeCompressedFile(compressor, componentFiles, outputFile);
        }
        return outputFilePath;
    }

    public static CompressedFile getSingleCompressedFile(String requestKey) {
        return CompressedFile.create(requestKey);
    }

    public String add(String fileName, boolean compress) {
        if (compress) {
            PressLogger.trace("Adding %s to output", fileName);
        } else {
            PressLogger.trace("Adding uncompressed file %s to output", fileName);
        }
        if (this.fileInfos.containsKey(fileName)) {
            throw new DuplicateFileException(this.fileType, fileName, this.tagName);
        }
        this.fileInfos.put(fileName, new FileInfo(fileName, compress, this.checkFileExists(fileName)));
        return this.getFileRequestSignature(fileName);
    }

    public String closeRequest() {
        if (this.requestKey != null) {
            String msg = "There is more than one " + this.compressedTagName + " tag in the template output. " + "There must be one only.";
            throw new PressException(msg);
        }
        this.requestKey = this.getRequestKey() + this.extension;
        PressLogger.trace("Adding key %s for compression of %d files", this.requestKey, this.fileInfos.size());
        return this.requestKey;
    }

    private String getRequestKey() {
        String key = "";
        for (Map.Entry<String, FileInfo> entry : this.fileInfos.entrySet()) {
            key = key + entry.getKey();
            if (!PluginConfig.cache.equals((Object)CachingStrategy.Change)) continue;
            key = key + entry.getValue().getLastModified();
        }
        String hashed = Crypto.passwordHash((String)key);
        return FileIO.lettersOnly(hashed);
    }

    public void saveFileList() {
        if (this.requestKey == null) {
            if (this.fileInfos.size() > 0) {
                String msg = this.fileInfos.size() + " files added to compression with ";
                msg = msg + this.tagName + " tag but no " + this.compressedTagName + " tag was found. ";
                msg = msg + "You must include a " + this.compressedTagName + " tag in the template ";
                msg = msg + "to output the compressed content of these files: ";
                msg = msg + JavaExtensions.join(this.fileInfos.keySet(), (String)", ");
                throw new PressException(msg);
            }
            return;
        }
        long timeStart = System.currentTimeMillis();
        List<FileInfo> orderedFileNames = this.getFileListOrder();
        long timeAfter = System.currentTimeMillis();
        PressLogger.trace("Time to scan response for %s files for '%s': %d milli-seconds", this.fileType, Http.Request.current().url, timeAfter - timeStart);
        this.addFileListToCache(this.requestKey, orderedFileNames);
    }

    public List<FileInfo> getFileListOrder() {
        String content = this.getResponseContent();
        List<String> namesInOrder = this.getFilesInResponse(content);
        ArrayList<FileInfo> filesInOrder = new ArrayList<FileInfo>(namesInOrder.size());
        if (namesInOrder.size() != this.fileInfos.size()) {
            String msg = "Number of file compress requests found in response ";
            msg = msg + "(" + namesInOrder.size() + ") ";
            msg = msg + "not equal to number of files added to compression ";
            msg = msg + "(" + this.fileInfos.size() + "). ";
            msg = msg + "Please report a bug.\n";
            msg = msg + "Note: Do not use press tags within a 404.html or 500.html ";
            msg = msg + "template, it will not work.";
            throw new PressException(msg);
        }
        for (String fileName : namesInOrder) {
            if (!this.fileInfos.containsKey(fileName)) {
                String msg = "File compress request for '" + fileName + "' ";
                msg = msg + "found in response but file was never added to file list. ";
                msg = msg + "Please report a bug.";
                throw new PressException(msg);
            }
            filesInOrder.add(this.fileInfos.get(fileName));
        }
        return filesInOrder;
    }

    public void addFileListToCache(String cacheKey, List<FileInfo> originalList) {
        ArrayList<FileInfo> newList = new ArrayList<FileInfo>();
        for (FileInfo fileInfo : originalList) {
            VirtualFile file = FileIO.getVirtualFile(this.srcDir + fileInfo.fileName);
            if (!file.exists()) {
                String msg = "Attempt to add file '" + file.getRealFile().getAbsolutePath() + "' ";
                msg = msg + "to compression with " + this.tagName + " tag but file does not exist.";
                throw new PressException(msg);
            }
            newList.add(new FileInfo(fileInfo.fileName, fileInfo.compress, file));
        }
        Cache.safeSet((String)cacheKey, newList, (String)PluginConfig.compressionKeyStorageTime);
    }

    protected static CompressedFile getCompressedFile(FileCompressor compressor, String key, String compressedDir, String extension) {
        List componentFiles = (List)Cache.get((String)key);
        if (componentFiles == null) {
            return null;
        }
        return Compressor.getCompressedFile(compressor, componentFiles, compressedDir, extension);
    }

    protected static CompressedFile getCompressedFile(FileCompressor compressor, List<FileInfo> componentFiles, String compressedDir, String extension) {
        String joinedFileNames = null;
        joinedFileNames = PluginConfig.cache.equals((Object)CachingStrategy.Change) ? JavaExtensions.join(FileInfo.getFileNamesAndModifiedTimestamps(componentFiles), (String)"") : JavaExtensions.join(FileInfo.getFileNames(componentFiles), (String)"");
        String fileName = Crypto.passwordHash((String)joinedFileNames);
        fileName = FileIO.lettersOnly(fileName);
        String filePath = compressedDir + fileName + extension;
        CompressedFile file = null;
        file = CompressedFile.create(filePath);
        boolean exists = file.exists();
        if (exists && Compressor.useCache(componentFiles, file, extension)) {
            PressLogger.trace("Using existing compressed file %s", filePath);
            return file;
        }
        if (!exists) {
            PressLogger.trace("Compressed file %s does not yet exist", filePath);
        }
        PressLogger.trace("Generating compressed file %s from %d component files", filePath, componentFiles.size());
        Compressor.writeCompressedFile(compressor, componentFiles, file);
        return file;
    }

    private static void writeCompressedFile(FileCompressor compressor, List<FileInfo> componentFiles, CompressedFile file) {
        long timeStart = System.currentTimeMillis();
        Writer writer = file.startWrite();
        if (writer == null) {
            PressLogger.trace("Compressed file was generated by another thread", new Object[0]);
            return;
        }
        try {
            writer.append(Compressor.createFileHeader());
            for (FileInfo componentFile : componentFiles) {
                Compressor.compress(compressor, componentFile, writer);
            }
            long timeAfter = System.currentTimeMillis();
            PressLogger.trace("Time to compress files for '%s': %d milli-seconds", FileIO.getFileNameFromPath(file.name()), timeAfter - timeStart);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        finally {
            file.close();
        }
    }

    public static int clearCache(String compressedDir, String extension) {
        return CompressedFile.clearCache(compressedDir, extension);
    }

    private static boolean useCache(List<FileInfo> componentFiles, CompressedFile file, String extension) {
        PressLogger.trace("Caching strategy is %s", new Object[]{PluginConfig.cache});
        return !PluginConfig.cache.equals((Object)CachingStrategy.Never);
    }

    public static String createFileHeader() {
        return "/*press-1.0*/\n";
    }

    public static boolean hasPressHeader(CompressedFile file) {
        try {
            if (!file.exists()) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(file.inputStream()));
            String firstLine = reader.readLine();
            Matcher matcher = HEADER_PATTERN.matcher(firstLine);
            return matcher.matches();
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void compress(FileCompressor compressor, FileInfo fileInfo, Writer out) throws Exception {
        String fileName = fileInfo.file.getName();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileInfo.file), "UTF-8"));
        if (fileInfo.compress) {
            PressLogger.trace("Compressing %s", fileName);
            compressor.compress(fileName, in, out);
        } else {
            PressLogger.trace("Adding already compressed file %s", fileName);
            FileIO.write(in, out);
            compressor.compress(fileName, in, out);
        }
    }

    protected String getResponseContent() {
        try {
            return this.currentResponse.out.toString("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected String getFileRequestSignature(String fileName) {
        return this.pressRequestStart + fileName + this.pressRequestEnd;
    }

    protected List<String> getFilesInResponse(String content) {
        ArrayList<String> filesInOrder = new ArrayList<String>();
        int startIndex = content.indexOf(this.pressRequestStart);
        while (startIndex != -1) {
            int endIndex = content.indexOf(this.pressRequestEnd, startIndex);
            if (endIndex == -1) {
                return filesInOrder;
            }
            int fileNameStartIndex = startIndex + this.pressRequestStart.length();
            String foundFileName = content.substring(fileNameStartIndex, endIndex);
            filesInOrder.add(foundFileName);
            startIndex = content.indexOf(this.pressRequestStart, endIndex);
        }
        return filesInOrder;
    }

    public VirtualFile checkFileExists(String fileName) {
        return FileIO.checkFileExists(fileName, this.srcDir);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FileInfo
    implements Serializable {
        String fileName;
        boolean compress;
        private File file;

        public FileInfo(String fileName, boolean compress, VirtualFile file) {
            this.fileName = fileName;
            this.compress = compress;
            this.file = file == null ? null : file.getRealFile();
        }

        public long getLastModified() {
            return this.file.lastModified();
        }

        public static Collection<String> getFileNames(List<FileInfo> list) {
            ArrayList<String> fileNames = new ArrayList<String>(list.size());
            for (FileInfo fileInfo : list) {
                fileNames.add(fileInfo.fileName);
            }
            return fileNames;
        }

        public static Collection<String> getFileNamesAndModifiedTimestamps(List<FileInfo> list) {
            ArrayList<String> fileNamesAndModifiedTimestamps = new ArrayList<String>(list.size());
            for (FileInfo fileInfo : list) {
                fileNamesAndModifiedTimestamps.add(fileInfo.fileName + fileInfo.getLastModified());
            }
            return fileNamesAndModifiedTimestamps;
        }
    }

    protected static interface FileCompressor {
        public void compress(String var1, Reader var2, Writer var3) throws Exception;
    }
}

