/*
 * Decompiled with CFR 0.152.
 */
package press.io;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import play.Play;
import play.exceptions.UnexpectedException;
import play.vfs.VirtualFile;
import press.PressException;

public class FileIO {
    public static VirtualFile getVirtualFile(String filePath) {
        VirtualFile vf = Play.getVirtualFile((String)filePath);
        if (vf == null) {
            return VirtualFile.open((File)Play.getFile((String)filePath));
        }
        return vf;
    }

    public static VirtualFile checkFileExists(String fileName, String sourceDirectory) {
        VirtualFile srcFile = FileIO.getVirtualFile(sourceDirectory + fileName);
        if (!srcFile.exists()) {
            String msg = "Attempt to add file '" + srcFile.getRealFile().getAbsolutePath() + "' ";
            msg = msg + "to compression but file does not exist.";
            throw new PressException(msg);
        }
        return srcFile;
    }

    public static void write(Reader reader, Writer writer) throws IOException {
        int read = 0;
        char[] buffer = new char[8096];
        while ((read = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, read);
        }
    }

    public static String getFileNameFromPath(String filePath) {
        int lastSlash = filePath.lastIndexOf(47);
        if (lastSlash != -1 && lastSlash < filePath.length()) {
            return filePath.substring(lastSlash + 1);
        }
        return filePath;
    }

    public static String lettersOnly(String hashed) {
        char[] chars = hashed.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i])) continue;
            chars[i] = (char)(65 + chars[i] % 26);
        }
        return new String(chars);
    }

    public static String escape(String url) {
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static String unescape(String url) {
        try {
            return URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

