/*
 * Decompiled with CFR 0.152.
 */
package press.io;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import play.Play;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PressFileGlobber {
    static Pattern pattern = Pattern.compile("(?:.*/)?(\\*\\*?)\\.(\\w+)");

    public static List<String> getResolvedFiles(String fileName, String sourceDir) {
        ArrayList<String> sources = new ArrayList<String>();
        Matcher m = pattern.matcher(fileName);
        if (!m.matches()) {
            sources.add(fileName);
            return sources;
        }
        String extension = m.group(2);
        boolean isRecursive = m.group(1).length() == 2;
        fileName = fileName.substring(0, fileName.length() - extension.length() - (isRecursive ? 3 : 2));
        String fullPath = Play.applicationPath.getAbsolutePath() + sourceDir;
        String[] extensionFilter = new String[]{extension};
        File startLookingFrom = new File(fullPath + fileName);
        Collection files = FileUtils.listFiles((File)startLookingFrom, (String[])extensionFilter, (boolean)isRecursive);
        for (File file : files) {
            String relativePath = file.getAbsolutePath().substring(fullPath.length());
            sources.add(relativePath);
        }
        Collections.sort(sources, Collator.getInstance(Locale.US));
        return sources;
    }
}

