/*
 * Decompiled with CFR 0.152.
 */
package press;

import play.Play;
import press.CachingStrategy;
import press.ConfigHelper;
import press.PressLogger;

public class PluginConfig {
    public static boolean enabled;
    public static CachingStrategy cache;
    public static boolean cacheClearEnabled;
    public static boolean inMemoryStorage;
    public static String compressionKeyStorageTime;
    public static int maxCompressionTimeMillis;
    public static boolean htmlCompatible;
    public static String contentHostingDomain;

    public static boolean isInMemoryStorage() {
        return inMemoryStorage;
    }

    public static void readConfig() {
        PressLogger.trace("Loading Press plugin configuration", new Object[0]);
        enabled = ConfigHelper.getBoolean("press.enabled", DefaultConfig.enabled);
        String cacheDefault = DefaultConfig.cache.toString();
        cache = CachingStrategy.parse(ConfigHelper.getString("press.cache", cacheDefault));
        cacheClearEnabled = ConfigHelper.getBoolean("press.cache.clearEnabled", DefaultConfig.cacheClearEnabled);
        inMemoryStorage = ConfigHelper.getBoolean("press.inMemoryStorage", false);
        compressionKeyStorageTime = ConfigHelper.getString("press.key.lifetime", "2mn");
        maxCompressionTimeMillis = ConfigHelper.getInt("press.compression.maxTimeMillis", 60000);
        htmlCompatible = ConfigHelper.getBoolean("press.htmlCompatible", false);
        contentHostingDomain = ConfigHelper.getString("press.contentHostingDomain", "");
        css.srcDir = ConfigHelper.getString("press.css.sourceDir", "/public/stylesheets/");
        css.compressedDir = ConfigHelper.getString("press.css.outputDir", "/public/stylesheets/press/");
        js.srcDir = ConfigHelper.getString("press.js.sourceDir", "/public/javascripts/");
        js.compressedDir = ConfigHelper.getString("press.js.outputDir", "/public/javascripts/press/");
        css.lineBreak = ConfigHelper.getInt("press.yui.css.lineBreak", -1);
        js.lineBreak = ConfigHelper.getInt("press.yui.js.lineBreak", -1);
        js.munge = ConfigHelper.getBoolean("press.yui.js.munge", true);
        js.warn = ConfigHelper.getBoolean("press.yui.js.warn", false);
        js.preserveAllSemiColons = ConfigHelper.getBoolean("press.yui.js.preserveAllSemiColons", false);
        js.preserveStringLiterals = ConfigHelper.getBoolean("press.yui.js.preserveStringLiterals", false);
        css.srcDir = PluginConfig.addTrailingSlash(css.srcDir);
        css.compressedDir = PluginConfig.addTrailingSlash(css.compressedDir);
        js.srcDir = PluginConfig.addTrailingSlash(js.srcDir);
        js.compressedDir = PluginConfig.addTrailingSlash(js.compressedDir);
        PluginConfig.logConfig();
    }

    private static void logConfig() {
        PressLogger.trace("enabled: %b", enabled);
        PressLogger.trace("caching strategy: %s", new Object[]{cache});
        PressLogger.trace("cache publicly clearable: %s", cacheClearEnabled);
        PressLogger.trace("in memory storage: %s", inMemoryStorage);
        PressLogger.trace("compression key storage time: %s", compressionKeyStorageTime);
        PressLogger.trace("HTML compatible: %b", htmlCompatible);
        PressLogger.trace("css source directory: %s", css.srcDir);
        PressLogger.trace("css compressed output directory: %s", css.compressedDir);
        PressLogger.trace("js source directory: %s", js.srcDir);
        PressLogger.trace("js compressed output directory: %s", js.compressedDir);
        PressLogger.trace("YUI css line break: %d", css.lineBreak);
        PressLogger.trace("YUI js line break: %d", js.lineBreak);
        PressLogger.trace("YUI js munge: %s", js.munge);
        PressLogger.trace("YUI js warn: %s", js.warn);
        PressLogger.trace("YUI js preserve all semi colons: %s", js.preserveAllSemiColons);
        PressLogger.trace("YUI js preserve string literals: %s", js.preserveStringLiterals);
    }

    public static String addTrailingSlash(String dir) {
        if (dir.charAt(dir.length() - 1) != '/') {
            return dir + '/';
        }
        return dir;
    }

    public static class css {
        public static String srcDir = "/public/stylesheets/";
        public static String compressedDir = "/public/stylesheets/press/";
        public static int lineBreak = -1;
    }

    public static class js {
        public static String srcDir = "/public/javascripts/";
        public static String compressedDir = "/public/javascripts/press/";
        public static int lineBreak = -1;
        public static boolean munge = true;
        public static boolean warn = false;
        public static boolean preserveAllSemiColons = false;
        public static boolean preserveStringLiterals = false;
    }

    public static class DefaultConfig {
        public static final boolean enabled = Play.mode == Play.Mode.PROD;
        public static final CachingStrategy cache = CachingStrategy.Change;
        public static final boolean cacheClearEnabled = Play.mode == Play.Mode.DEV;
        public static final boolean inMemoryStorage = false;
        public static final String compressionKeyStorageTime = "2mn";
        public static final int maxCompressionTimeMillis = 60000;
        public static final boolean htmlCompatible = false;
        public static final String contentHostingDomain = "";

        public static class css {
            public static final String srcDir = "/public/stylesheets/";
            public static final String compressedDir = "/public/stylesheets/press/";
            public static final int lineBreak = -1;
        }

        public static class js {
            public static final String srcDir = "/public/javascripts/";
            public static final String compressedDir = "/public/javascripts/press/";
            public static final int lineBreak = -1;
            public static final boolean munge = true;
            public static final boolean warn = false;
            public static final boolean preserveAllSemiColons = false;
            public static final boolean preserveStringLiterals = false;
        }
    }
}

