/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.util.HashMap;
import java.util.Map;
import play.mvc.Router;
import press.Compressor;
import press.DuplicateFileException;
import press.SourceFileManager;
import press.io.FileIO;

public abstract class RequestHandler {
    Map<String, Boolean> files = new HashMap<String, Boolean>();

    protected abstract SourceFileManager getSourceManager();

    protected abstract Compressor getCompressor();

    abstract String getSingleCompressedUrl(String var1);

    public abstract String getMultiCompressedUrl(String var1);

    abstract String getTag(String var1);

    public String getSrcDir() {
        return this.getSourceManager().srcDir;
    }

    public void checkFileExists(String fileName) {
        FileIO.checkFileExists(fileName, this.getSrcDir());
    }

    public String compressedSingleFileUrl(String fileName) {
        return this.getCompressor().compressedSingleFileUrl(fileName);
    }

    public String add(String fileName, boolean packFile) {
        return this.getSourceManager().add(fileName, packFile);
    }

    public void saveFileList() {
        this.getSourceManager().saveFileList();
    }

    public String closeRequest() {
        return this.getSourceManager().closeRequest();
    }

    protected void checkForDuplicates(String fileName) {
        if (!this.files.containsKey(fileName)) {
            this.files.put(fileName, true);
            return;
        }
        SourceFileManager srcManager = this.getSourceManager();
        throw new DuplicateFileException(srcManager.getFileType(), fileName, srcManager.getTagName());
    }

    protected static String getCompressedUrl(String action, String requestKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", FileIO.escape(requestKey));
        return Router.reverse((String)action, params).url;
    }
}

