/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.PlayPlugin;
import play.cache.Cache;
import play.exceptions.UnexpectedException;
import play.libs.Crypto;
import play.mvc.Http;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;
import press.CachingStrategy;
import press.DuplicateFileException;
import press.FileInfo;
import press.PluginConfig;
import press.PressException;
import press.PressLogger;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceFileManager
extends PlayPlugin {
    String fileType;
    String extension;
    String tagName;
    String compressedTagName;
    String pressRequestStart;
    String pressRequestEnd;
    String srcDir;
    String requestKey = null;
    Http.Response currentResponse;
    Map<String, FileInfo> fileInfos = new HashMap<String, FileInfo>();

    public SourceFileManager(String fileType, String extension, String tagName, String compressedTagName, String pressRequestStart, String pressRequestEnd, String srcDir) {
        this.currentResponse = Http.Response.current();
        this.fileType = fileType;
        this.extension = extension;
        this.pressRequestStart = pressRequestStart;
        this.pressRequestEnd = pressRequestEnd;
        this.tagName = tagName;
        this.compressedTagName = compressedTagName;
        this.srcDir = PluginConfig.addTrailingSlash(srcDir);
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String add(String fileName, boolean compress) {
        if (compress) {
            PressLogger.trace("Adding %s to output", fileName);
        } else {
            PressLogger.trace("Adding uncompressed file %s to output", fileName);
        }
        if (this.fileInfos.containsKey(fileName)) {
            throw new DuplicateFileException(this.fileType, fileName, this.tagName);
        }
        this.fileInfos.put(fileName, new FileInfo(fileName, compress, this.checkFileExists(fileName)));
        return this.getFileRequestSignature(fileName);
    }

    public String closeRequest() {
        if (this.requestKey != null) {
            String msg = "There is more than one " + this.compressedTagName + " tag in the template output. " + "There must be one only.";
            throw new PressException(msg);
        }
        this.requestKey = this.getRequestKey() + this.extension;
        PressLogger.trace("Adding key %s for compression of %d files", this.requestKey, this.fileInfos.size());
        return this.requestKey;
    }

    private String getRequestKey() {
        String key = "";
        for (Map.Entry<String, FileInfo> entry : this.fileInfos.entrySet()) {
            key = key + entry.getKey();
            if (!PluginConfig.cache.equals((Object)CachingStrategy.Change)) continue;
            key = key + entry.getValue().getLastModified();
        }
        String hashed = Crypto.passwordHash((String)key);
        return FileIO.lettersOnly(hashed);
    }

    public void saveFileList() {
        if (this.requestKey == null) {
            if (this.fileInfos.size() > 0) {
                String msg = this.fileInfos.size() + " files added to compression with ";
                msg = msg + this.tagName + " tag but no " + this.compressedTagName + " tag was found. ";
                msg = msg + "You must include a " + this.compressedTagName + " tag in the template ";
                msg = msg + "to output the compressed content of these files: ";
                msg = msg + JavaExtensions.join(this.fileInfos.keySet(), (String)", ");
                throw new PressException(msg);
            }
            return;
        }
        long timeStart = System.currentTimeMillis();
        List<FileInfo> orderedFileNames = this.getFileListOrder();
        long timeAfter = System.currentTimeMillis();
        PressLogger.trace("Time to scan response for %s files for '%s': %d milli-seconds", this.fileType, Http.Request.current().url, timeAfter - timeStart);
        this.addFileListToCache(this.requestKey, orderedFileNames);
    }

    public List<FileInfo> getFileListOrder() {
        String content = this.getResponseContent();
        List<String> namesInOrder = this.getFilesInResponse(content);
        ArrayList<FileInfo> filesInOrder = new ArrayList<FileInfo>(namesInOrder.size());
        if (namesInOrder.size() != this.fileInfos.size()) {
            String msg = "Number of file compress requests found in response ";
            msg = msg + "(" + namesInOrder.size() + ") ";
            msg = msg + "not equal to number of files added to compression ";
            msg = msg + "(" + this.fileInfos.size() + "). ";
            msg = msg + "Please report a bug.\n";
            msg = msg + "Note: Do not use press tags within a 404.html or 500.html ";
            msg = msg + "template, it will not work.";
            throw new PressException(msg);
        }
        for (String fileName : namesInOrder) {
            if (!this.fileInfos.containsKey(fileName)) {
                String msg = "File compress request for '" + fileName + "' ";
                msg = msg + "found in response but file was never added to file list. ";
                msg = msg + "Please report a bug.";
                throw new PressException(msg);
            }
            filesInOrder.add(this.fileInfos.get(fileName));
        }
        return filesInOrder;
    }

    public void addFileListToCache(String cacheKey, List<FileInfo> originalList) {
        ArrayList<FileInfo> newList = new ArrayList<FileInfo>();
        for (FileInfo fileInfo : originalList) {
            VirtualFile file = FileIO.getVirtualFile(this.srcDir + fileInfo.fileName);
            if (!file.exists()) {
                String msg = "Attempt to add file '" + file.getRealFile().getAbsolutePath() + "' ";
                msg = msg + "to compression with " + this.tagName + " tag but file does not exist.";
                throw new PressException(msg);
            }
            newList.add(new FileInfo(fileInfo.fileName, fileInfo.compress, file));
        }
        Cache.safeSet((String)cacheKey, newList, (String)PluginConfig.compressionKeyStorageTime);
    }

    protected String getResponseContent() {
        try {
            return this.currentResponse.out.toString("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected String getFileRequestSignature(String fileName) {
        return this.pressRequestStart + fileName + this.pressRequestEnd;
    }

    protected List<String> getFilesInResponse(String content) {
        ArrayList<String> filesInOrder = new ArrayList<String>();
        int startIndex = content.indexOf(this.pressRequestStart);
        while (startIndex != -1) {
            int endIndex = content.indexOf(this.pressRequestEnd, startIndex);
            if (endIndex == -1) {
                return filesInOrder;
            }
            int fileNameStartIndex = startIndex + this.pressRequestStart.length();
            String foundFileName = content.substring(fileNameStartIndex, endIndex);
            filesInOrder.add(foundFileName);
            startIndex = content.indexOf(this.pressRequestStart, endIndex);
        }
        return filesInOrder;
    }

    public VirtualFile checkFileExists(String fileName) {
        return FileIO.checkFileExists(fileName, this.srcDir);
    }

    public static List<FileInfo> getSourceFiles(String key) {
        return (List)Cache.get((String)key);
    }
}

