/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.libs.Crypto;
import play.templates.JavaExtensions;
import play.vfs.VirtualFile;
import press.CachingStrategy;
import press.FileInfo;
import press.PluginConfig;
import press.PressLogger;
import press.SourceFileManager;
import press.io.CompressedFile;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Compressor
extends PlayPlugin {
    static final String PRESS_SIGNATURE = "press-1.0";
    static final String PATTERN_TEXT = "^/\\*press-1.0\\*/$";
    static final Pattern HEADER_PATTERN = Pattern.compile("^/\\*press-1.0\\*/$");
    String srcDir;
    String compressedDir;
    private String extension;

    public Compressor(String srcDir, String compressedDir, String extension) {
        this.srcDir = PluginConfig.addTrailingSlash(srcDir);
        this.compressedDir = PluginConfig.addTrailingSlash(compressedDir);
        this.extension = extension;
    }

    public String compressedSingleFileUrl(String fileName) {
        PressLogger.trace("Request to compress single file %s", fileName);
        VirtualFile srcFile = FileIO.checkFileExists(fileName, this.srcDir);
        int lastDot = fileName.lastIndexOf(46);
        String compressedFileName = fileName.substring(0, lastDot) + "." + srcFile.lastModified() + ".min";
        compressedFileName = compressedFileName + fileName.substring(lastDot);
        ArrayList<FileInfo> componentFiles = new ArrayList<FileInfo>(1);
        componentFiles.add(new FileInfo(compressedFileName, true, srcFile));
        String outputFilePath = this.compressedDir + compressedFileName;
        CompressedFile outputFile = CompressedFile.create(outputFilePath);
        if (outputFile.exists() && Compressor.useCache()) {
            PressLogger.trace("File has already been compressed", new Object[0]);
        } else {
            this.writeCompressedFile(componentFiles, outputFile);
        }
        return outputFilePath;
    }

    public CompressedFile getSingleCompressedFile(String requestKey) {
        return CompressedFile.create(requestKey);
    }

    public CompressedFile getCompressedFile(String key) {
        List<FileInfo> componentFiles = SourceFileManager.getSourceFiles(key);
        if (componentFiles == null) {
            return null;
        }
        return this.getCompressedFile(componentFiles, this.compressedDir);
    }

    protected CompressedFile getCompressedFile(List<FileInfo> componentFiles, String compressedDir) {
        String joinedFileNames = null;
        joinedFileNames = PluginConfig.cache.equals((Object)CachingStrategy.Change) ? JavaExtensions.join(FileInfo.getFileNamesAndModifiedTimestamps(componentFiles), (String)"") : JavaExtensions.join(FileInfo.getFileNames(componentFiles), (String)"");
        String fileName = Crypto.passwordHash((String)joinedFileNames);
        fileName = FileIO.lettersOnly(fileName);
        String filePath = compressedDir + fileName + this.extension;
        CompressedFile file = null;
        file = CompressedFile.create(filePath);
        boolean exists = file.exists();
        if (exists && Compressor.useCache()) {
            PressLogger.trace("Using existing compressed file %s", filePath);
            return file;
        }
        if (!exists) {
            PressLogger.trace("Compressed file %s does not yet exist", filePath);
        }
        PressLogger.trace("Generating compressed file %s from %d component files", filePath, componentFiles.size());
        this.writeCompressedFile(componentFiles, file);
        return file;
    }

    private void writeCompressedFile(List<FileInfo> componentFiles, CompressedFile file) {
        long timeStart = System.currentTimeMillis();
        Writer writer = file.startWrite();
        if (writer == null) {
            PressLogger.trace("Compressed file was generated by another thread", new Object[0]);
            return;
        }
        try {
            writer.append(Compressor.createFileHeader());
            for (FileInfo componentFile : componentFiles) {
                this.compress(componentFile, writer);
            }
            long timeAfter = System.currentTimeMillis();
            PressLogger.trace("Time to compress files for '%s': %d milli-seconds", FileIO.getFileNameFromPath(file.name()), timeAfter - timeStart);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        finally {
            file.close();
        }
    }

    private void compress(FileInfo fileInfo, Writer out) throws Exception {
        String fileName = fileInfo.file.getName();
        if (fileInfo.compress) {
            PressLogger.trace("Compressing %s", fileName);
            this.compress(fileInfo.file, out);
        } else {
            PressLogger.trace("Adding already compressed file %s", fileName);
            FileIO.write(FileIO.getReader(fileInfo.file), out);
        }
    }

    public static int clearCache(String compressedDir, String extension) {
        return CompressedFile.clearCache(compressedDir, extension);
    }

    private static boolean useCache() {
        PressLogger.trace("Caching strategy is %s", new Object[]{PluginConfig.cache});
        return !PluginConfig.cache.equals((Object)CachingStrategy.Never);
    }

    public static String createFileHeader() {
        return "/*press-1.0*/\n";
    }

    public static boolean hasPressHeader(CompressedFile file) {
        try {
            if (!file.exists()) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(file.inputStream()));
            String firstLine = reader.readLine();
            Matcher matcher = HEADER_PATTERN.matcher(firstLine);
            return matcher.matches();
        }
        catch (IOException e) {
            return false;
        }
    }

    protected abstract void compress(File var1, Writer var2) throws IOException;
}

