/*
 * Decompiled with CFR 0.152.
 */
package press;

import press.PluginConfig;
import press.RequestHandler;
import press.ScriptRequestHandler;
import press.StyleRequestHandler;
import press.io.PressFileGlobber;

public class RequestManager {
    public static final boolean RQ_TYPE_SCRIPT = true;
    public static final boolean RQ_TYPE_STYLE = false;
    private boolean errorOccurred = false;
    private RequestHandler scriptRequestHandler = new ScriptRequestHandler();
    private RequestHandler styleRequestHandler = new StyleRequestHandler();

    private RequestHandler getRequestHandler(boolean rqType) {
        return rqType ? this.scriptRequestHandler : this.styleRequestHandler;
    }

    public String addSingleFile(boolean rqType, String fileName) {
        RequestHandler handler = this.getRequestHandler(rqType);
        handler.checkFileExists(fileName);
        String src = null;
        if (this.performCompression()) {
            String requestKey = handler.compressedSingleFileUrl(fileName);
            src = PluginConfig.isInMemoryStorage() ? handler.getSingleCompressedUrl(requestKey) : requestKey;
        } else {
            src = handler.getSrcDir() + fileName;
        }
        return handler.getTag(src);
    }

    public String addMultiFile(boolean rqType, String src, boolean packFile) {
        RequestHandler handler = this.getRequestHandler(rqType);
        String baseUrl = handler.getSrcDir();
        String result = "";
        for (String fileName : PressFileGlobber.getResolvedFiles(src, baseUrl)) {
            handler.checkFileExists(fileName);
            handler.checkForDuplicates(fileName);
            if (this.performCompression()) {
                result = result + handler.add(fileName, packFile) + "\n";
                continue;
            }
            result = result + handler.getTag(baseUrl + fileName);
        }
        return result;
    }

    public String compressedTag(boolean rqType) {
        RequestHandler handler = this.getRequestHandler(rqType);
        if (this.performCompression()) {
            String requestKey = handler.closeRequest();
            return handler.getTag(handler.getMultiCompressedUrl(requestKey));
        }
        return "";
    }

    public void saveFileList() {
        if (!this.performCompression()) {
            return;
        }
        this.scriptRequestHandler.saveFileList();
        this.styleRequestHandler.saveFileList();
    }

    public void errorOccurred() {
        this.errorOccurred = true;
    }

    private boolean performCompression() {
        return PluginConfig.enabled && !this.errorOccurred;
    }

    public static void clearCache() {
        ScriptRequestHandler.clearCache();
        StyleRequestHandler.clearCache();
    }
}

