/*
 * Decompiled with CFR 0.152.
 */
package press;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import play.Logger;
import press.Compressor;
import press.PluginConfig;
import press.io.FileIO;

public class ScriptCompressor
extends Compressor {
    public static final String EXTENSION = ".js";

    public ScriptCompressor() {
        super(PluginConfig.js.srcDir, PluginConfig.js.compressedDir, EXTENSION);
    }

    public static int clearCache() {
        return ScriptCompressor.clearCache(PluginConfig.js.compressedDir, EXTENSION);
    }

    public void compress(File sourceFile, Writer out) throws IOException {
        PressErrorReporter errorReporter = new PressErrorReporter(sourceFile.getName());
        Reader in = FileIO.getReader(sourceFile);
        JavaScriptCompressor compressor = new JavaScriptCompressor(in, (ErrorReporter)errorReporter);
        compressor.compress(out, PluginConfig.js.lineBreak, PluginConfig.js.munge, PluginConfig.js.warn, PluginConfig.js.preserveAllSemiColons, PluginConfig.js.preserveStringLiterals);
    }

    static class PressErrorReporter
    implements ErrorReporter {
        private static final String PREFIX = "[YUI Compressor] ";
        private static final String FORMAT_STRING = "%s:%d (char %d) %s";
        String fileName;

        public PressErrorReporter(String fileName) {
            this.fileName = fileName;
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0 || line == 1 && lineOffset == 0) {
                Logger.warn((String)(PREFIX + message), (Object[])new Object[0]);
            } else {
                Logger.warn((String)"[YUI Compressor] %s:%d (char %d) %s", (Object[])new Object[]{this.fileName, line, lineOffset, message});
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0 || line == 1 && lineOffset == 0) {
                Logger.error((String)(PREFIX + message), (Object[])new Object[0]);
            } else {
                Logger.error((String)"[YUI Compressor] %s:%d (char %d) %s", (Object[])new Object[]{this.fileName, line, lineOffset, message});
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

