/*
 * Decompiled with CFR 0.152.
 */
package press;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import press.Compressor;
import press.PluginConfig;
import press.io.FileIO;

public class StyleCompressor
extends Compressor {
    public static final String EXTENSION = ".css";

    public StyleCompressor() {
        super(PluginConfig.css.srcDir, PluginConfig.css.compressedDir, EXTENSION);
    }

    public static int clearCache() {
        return StyleCompressor.clearCache(PluginConfig.css.compressedDir, EXTENSION);
    }

    public void compress(File sourceFile, Writer out) throws IOException {
        try {
            Reader in;
            if (StyleCompressor.isLess(sourceFile.getName())) {
                LessEngine engine = new LessEngine();
                String css2 = engine.compile(sourceFile);
                in = new BufferedReader(new StringReader(css2));
            } else {
                in = FileIO.getReader(sourceFile);
            }
            CssCompressor compressor = new CssCompressor(in);
            compressor.compress(out, PluginConfig.css.lineBreak);
        }
        catch (LessException e) {
            throw new IOException(e);
        }
    }

    public static boolean isLess(String fileName) {
        return fileName.toLowerCase().endsWith(".less");
    }
}

