/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.exceptions.UnexpectedException;
import press.Compressor;
import press.FileInfo;
import press.PressLogger;
import press.io.CompressedFile;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PressFileWriter {
    static final String PRESS_SIGNATURE = "press-1.0";
    static final String PATTERN_TEXT = "^/\\*press-1.0\\*/$";
    static final Pattern HEADER_PATTERN = Pattern.compile("^/\\*press-1.0\\*/$");
    private Compressor compressor;

    public PressFileWriter(Compressor compressor) {
        this.compressor = compressor;
    }

    public CompressedFile writeCompressedFile(List<FileInfo> componentFiles, CompressedFile file) {
        long timeStart = System.currentTimeMillis();
        Writer writer = file.startWrite();
        if (writer == null) {
            PressLogger.trace("Compressed file was generated by another thread", new Object[0]);
            return file;
        }
        try {
            writer.append(PressFileWriter.createFileHeader());
            for (FileInfo componentFile : componentFiles) {
                this.compress(componentFile, writer);
            }
            long timeAfter = System.currentTimeMillis();
            PressLogger.trace("Time to compress files for '%s': %d milli-seconds", FileIO.getFileNameFromPath(file.name()), timeAfter - timeStart);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        finally {
            file.close();
        }
        return file;
    }

    private void compress(FileInfo fileInfo, Writer out) throws Exception {
        String fileName = fileInfo.file.getName();
        if (fileInfo.compress) {
            PressLogger.trace("Compressing %s", fileName);
        } else {
            PressLogger.trace("Adding already compressed file %s", fileName);
        }
        this.compressor.compress(fileInfo.file, out, fileInfo.compress);
    }

    public static String createFileHeader() {
        return "/*press-1.0*/\n";
    }

    public static boolean hasPressHeader(CompressedFile file) {
        try {
            if (!file.exists()) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(file.inputStream()));
            String firstLine = reader.readLine();
            Matcher matcher = HEADER_PATTERN.matcher(firstLine);
            return matcher.matches();
        }
        catch (IOException e) {
            return false;
        }
    }
}

