/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.lang.reflect.Method;
import play.PlayPlugin;
import press.PluginConfig;
import press.RequestManager;

public class Plugin
extends PlayPlugin {
    static ThreadLocal<RequestManager> rqManager = new ThreadLocal();

    public void onApplicationStart() {
        PluginConfig.readConfig();
        RequestManager.clearCache();
    }

    public void beforeActionInvocation(Method actionMethod) {
        rqManager.set(new RequestManager());
    }

    public static String addSingleJS(String fileName) {
        return rqManager.get().addSingleFile(true, fileName);
    }

    public static String addSingleCSS(String fileName) {
        return rqManager.get().addSingleFile(false, fileName);
    }

    public static String addJS(String src, boolean packFile) {
        return rqManager.get().addMultiFile(true, src, packFile);
    }

    public static String addCSS(String src, boolean packFile) {
        return rqManager.get().addMultiFile(false, src, packFile);
    }

    public static String compressedJSTag() {
        return rqManager.get().compressedTag(true);
    }

    public static String compressedCSSTag() {
        return rqManager.get().compressedTag(false);
    }

    public void afterActionInvocation() {
        if (rqManager.get() != null) {
            rqManager.get().saveFileList();
        }
        rqManager.set(null);
    }

    public void onInvocationException(Throwable e) {
        if (rqManager.get() != null) {
            rqManager.get().errorOccurred();
        }
    }
}

