/*
 * Decompiled with CFR 0.152.
 */
package press;

import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import press.CacheManager;
import press.Compressor;
import press.FileInfo;
import press.PlayLessEngine;
import press.PluginConfig;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleCompressor
extends Compressor {
    private static final String COMPRESSED_DIR = PluginConfig.css.compressedDir;
    public static final String EXTENSION = ".css";
    public static final PlayLessEngine lessEngine = new PlayLessEngine();

    public static int clearCache() {
        return StyleCompressor.clearCache(COMPRESSED_DIR, EXTENSION);
    }

    @Override
    public void compress(File sourceFile, Writer out, boolean compress) throws IOException {
        Reader in;
        if (StyleCompressor.isLess(sourceFile.getName())) {
            String css2 = lessEngine.get(sourceFile, compress);
            in = new StringReader(css2);
        } else {
            in = FileIO.getReader(sourceFile);
        }
        if (compress) {
            CssCompressor compressor = new CssCompressor(in);
            compressor.compress(out, PluginConfig.css.lineBreak);
        } else {
            FileIO.write(in, out);
        }
    }

    public static boolean isLess(String fileName) {
        return fileName.toLowerCase().endsWith(".less");
    }

    @Override
    public String getCompressedFileKey(List<FileInfo> componentFiles) {
        Map<String, Long> files = FileInfo.getFileLastModifieds(componentFiles);
        for (String filePath : files.keySet()) {
            File lessFile;
            if (!StyleCompressor.isLess(filePath) || !(lessFile = new File(filePath)).exists()) continue;
            files.put(filePath, PlayLessEngine.latestModified(lessFile));
        }
        return CacheManager.getCompressedFileKey(files, EXTENSION);
    }
}

