/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.util.Map;
import play.libs.Crypto;
import press.CachingStrategy;
import press.PluginConfig;
import press.PressLogger;
import press.io.CompressedFile;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    public static boolean useCachedFile(CompressedFile file) {
        String filePath = file.getFileKey();
        if (file.exists() && CacheManager.useCache()) {
            PressLogger.trace("Using existing compressed file %s", filePath);
            return true;
        }
        if (!file.exists()) {
            PressLogger.trace("Compressed file %s does not yet exist", filePath);
        }
        PressLogger.trace("Generating compressed file %s", filePath);
        return false;
    }

    private static boolean useCache() {
        PressLogger.trace("Caching strategy is %s", new Object[]{PluginConfig.cache});
        return !PluginConfig.cache.equals((Object)CachingStrategy.Never);
    }

    public static String getCompressedFileKey(Map<String, Long> files, String extension) {
        StringBuffer key = new StringBuffer();
        for (String filePath : files.keySet()) {
            key.append(filePath);
            key.append(files.get(filePath));
        }
        return FileIO.lettersOnly(Crypto.passwordHash((String)key.toString())) + extension;
    }
}

