/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.util.List;
import press.CacheManager;
import press.Compressor;
import press.FileInfo;
import press.PressFileWriter;
import press.SourceFileManager;
import press.io.CompressedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompressedFileManager {
    private PressFileWriter pressFileWriter;
    private Compressor compressor;

    public CompressedFileManager(Compressor compressor) {
        this.compressor = compressor;
        this.pressFileWriter = new PressFileWriter(compressor);
    }

    public CompressedFile getCompressedFile(String key) {
        List<FileInfo> componentFiles = SourceFileManager.getSourceFiles(key);
        if (componentFiles == null) {
            return null;
        }
        return this.getCompressedFile(componentFiles);
    }

    public CompressedFile getCompressedFile(List<FileInfo> componentFiles) {
        String key = this.compressor.getCompressedFileKey(componentFiles);
        CompressedFile file = CompressedFile.create(key, this.getCompressedDir());
        if (CacheManager.useCachedFile(file)) {
            return file;
        }
        return this.pressFileWriter.writeCompressedFile(componentFiles, file);
    }

    public abstract String getCompressedDir();
}

