/*
 * Decompiled with CFR 0.152.
 */
package press.io;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import play.cache.Cache;
import play.exceptions.UnexpectedException;
import press.PluginConfig;
import press.PressException;
import press.PressLogger;
import press.io.CompressedFile;
import press.io.FileIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCompressedFile
extends CompressedFile {
    private static final String FILE_LIST_KEY = "InMemoryFileList";
    private InputStream inputStream;
    private Writer writer;
    private ByteArrayOutputStream outputStream;
    private byte[] bytes;
    private static final String A_VERY_LONG_TIME = "3650d";

    public InMemoryCompressedFile(String fileKey) {
        super(fileKey);
    }

    @Override
    public boolean exists() {
        if (this.inputStream != null) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        this.bytes = (byte[])Cache.get((String)this.getCacheKey());
        if (this.bytes != null) {
            long totalTime = System.currentTimeMillis() - startTime;
            PressLogger.trace("Got file of size %d bytes from cache in %d milli-seconds.", this.bytes.length, totalTime);
            this.inputStream = new ByteArrayInputStream(this.bytes);
            return true;
        }
        return false;
    }

    @Override
    public InputStream inputStream() {
        if (!this.exists()) {
            throw new PressException("Can't create InputStream. File with key " + this.getCacheKey() + " does not exist in cache");
        }
        return this.inputStream;
    }

    @Override
    public String name() {
        return FileIO.getFileNameFromPath(this.getFileKey());
    }

    @Override
    public Writer startWrite() {
        String inProgressKey = InMemoryCompressedFile.getInProgressKey(this.getFileKey());
        if (Cache.get((String)inProgressKey) != null) {
            return null;
        }
        String expiration = PluginConfig.maxCompressionTimeMillis / 1000 + "s";
        Cache.safeSet((String)inProgressKey, (Object)true, (String)expiration);
        if (this.writer == null) {
            this.outputStream = new ByteArrayOutputStream();
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.outputStream, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
        return this.writer;
    }

    @Override
    public void close() {
        if (this.writer == null) {
            throw new PressException("Output stream has not yet been created. Call getWriter() and write to it.");
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
        byte[] outBytes = this.outputStream.toByteArray();
        PressLogger.trace("Saving file of size %d bytes to cache.", outBytes.length);
        this.addFileToCache(this.getFileKey(), outBytes);
        String inProgressKey = InMemoryCompressedFile.getInProgressKey(this.getFileKey());
        Cache.safeDelete((String)inProgressKey);
    }

    private static String getInProgressKey(String fileKey) {
        return "in-progress-" + fileKey;
    }

    private String getCacheKey() {
        return InMemoryCompressedFile.getCacheKey(this.getFileKey());
    }

    private static String getCacheKey(String fileKey) {
        return "file-" + fileKey;
    }

    private void addFileToCache(String fileKey, byte[] outBytes) {
        long startTime = System.currentTimeMillis();
        Set<String> fileList = InMemoryCompressedFile.getFileList();
        fileList.add(fileKey);
        Cache.set((String)FILE_LIST_KEY, fileList, (String)A_VERY_LONG_TIME);
        String cacheKey = InMemoryCompressedFile.getCacheKey(fileKey);
        if (!Cache.safeSet((String)cacheKey, (Object)outBytes, (String)A_VERY_LONG_TIME)) {
            throw new PressException("Underlying cache implementation could not store compressed file " + fileKey + " in cache");
        }
        this.inputStream = null;
        this.bytes = null;
        long totalTime = System.currentTimeMillis() - startTime;
        PressLogger.trace("Saved file to cache in %d milli-seconds", totalTime);
    }

    public static int clearMemoryCache(String extension) {
        Set<String> files = InMemoryCompressedFile.getFileList();
        for (String fileKey : files) {
            Cache.delete((String)InMemoryCompressedFile.getCacheKey(fileKey));
            Cache.delete((String)InMemoryCompressedFile.getInProgressKey(fileKey));
        }
        Cache.delete((String)FILE_LIST_KEY);
        return files.size();
    }

    private static Set<String> getFileList() {
        HashSet fileList = (HashSet)Cache.get((String)FILE_LIST_KEY);
        if (fileList == null) {
            fileList = new HashSet();
        }
        return fileList;
    }

    @Override
    public long length() {
        if (!this.exists()) {
            throw new PressException("Can't get length. File with key " + this.getCacheKey() + " does not exist in cache");
        }
        return this.bytes.length;
    }
}

