/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.lang.reflect.Method;
import play.PlayPlugin;
import play.mvc.Http;
import play.vfs.VirtualFile;
import press.PluginConfig;
import press.RequestManager;
import press.StaticAssetManager;

public class Plugin
extends PlayPlugin {
    static ThreadLocal<RequestManager> rqManager = new ThreadLocal();
    static StaticAssetManager assetManager;

    public void onApplicationStart() {
        PluginConfig.readConfig();
        RequestManager.clearCache();
        assetManager = new StaticAssetManager();
    }

    public void beforeActionInvocation(Method actionMethod) {
        rqManager.set(new RequestManager());
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        return assetManager.serveStatic(file, request, response);
    }

    public static String addSingleJS(String fileName) {
        return rqManager.get().addSingleFile(true, fileName);
    }

    public static String addSingleCSS(String fileName) {
        return rqManager.get().addSingleFile(false, fileName);
    }

    public static String addJS(String src, boolean packFile) {
        return rqManager.get().addMultiFile(true, src, packFile);
    }

    public static String addCSS(String src, boolean packFile) {
        return rqManager.get().addMultiFile(false, src, packFile);
    }

    public static String compressedJSTag() {
        return rqManager.get().compressedTag(true);
    }

    public static String compressedCSSTag() {
        return rqManager.get().compressedTag(false);
    }

    public void afterActionInvocation() {
        if (rqManager.get() != null) {
            rqManager.get().saveFileList();
        }
        rqManager.set(null);
    }

    public void onInvocationException(Throwable e) {
        if (rqManager.get() != null) {
            rqManager.get().errorOccurred();
        }
    }
}

