/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.util.HashMap;
import java.util.Map;
import play.mvc.Router;
import play.vfs.VirtualFile;
import press.CompressedFileManager;
import press.DuplicateFileException;
import press.PressLogger;
import press.SourceFileManager;
import press.io.FileIO;

public abstract class RequestHandler {
    Map<String, Boolean> files = new HashMap<String, Boolean>();

    abstract String getTag(String var1);

    protected abstract SourceFileManager getSourceManager();

    protected abstract CompressedFileManager getCompressedFileManager();

    public abstract String getCompressedUrl(String var1);

    public abstract String getSingleFileCompressionKey(String var1);

    protected String getSingleFileCompressionKey(String fileName, SourceFileManager tmpManager) {
        PressLogger.trace("Request to compress single file %s", fileName);
        return tmpManager.addSingleFile(fileName, true);
    }

    public String getSrcDir() {
        return this.getSourceManager().srcDir;
    }

    public VirtualFile checkFileExists(String fileName) {
        return this.getSourceManager().checkFileExists(fileName);
    }

    public String add(String fileName, boolean packFile) {
        return this.getSourceManager().add(fileName, packFile);
    }

    public void saveFileList() {
        this.getSourceManager().saveFileList();
    }

    public String closeRequest() {
        return this.getSourceManager().closeRequest();
    }

    protected void checkForDuplicates(String fileName) {
        if (!this.files.containsKey(fileName)) {
            this.files.put(fileName, true);
            return;
        }
        SourceFileManager srcManager = this.getSourceManager();
        throw new DuplicateFileException(srcManager.getFileType(), fileName, srcManager.getTagName());
    }

    protected static String getCompressedUrl(String action, String requestKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", FileIO.escape(requestKey));
        return Router.reverse((String)action, params).url;
    }
}

