/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.io.PrintStream;
import java.util.Date;
import play.Play;
import play.mvc.Http;
import play.utils.Utils;
import play.vfs.VirtualFile;
import press.PlayLessEngine;
import press.PluginConfig;
import press.StyleCompressor;

public class StaticAssetManager {
    long startTime = System.currentTimeMillis();

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        if (file.getName().endsWith(".less")) {
            if (PluginConfig.outputRawLess) {
                response.contentType = "text/less";
                return false;
            }
            response.contentType = "text/css";
            try {
                this.handleResponse(file, request, response);
            }
            catch (Exception e) {
                response.status = 500;
                response.print((Object)"LESS processing failed:\n");
                e.printStackTrace(new PrintStream(response.out));
            }
            return true;
        }
        return false;
    }

    private void handleResponse(VirtualFile file, Http.Request request, Http.Response response) {
        boolean reprocessFile;
        long lastModified = PlayLessEngine.latestModified(file.getRealFile());
        String etag = "\"" + lastModified + "-" + file.hashCode() + "\"";
        boolean bl = reprocessFile = Play.mode.equals((Object)Play.Mode.DEV) && this.startTime > lastModified;
        if (request.isModified(etag, lastModified) || reprocessFile) {
            this.handleOk(request, response, file, etag, lastModified);
        } else {
            this.handleNotModified(request, response, etag);
        }
    }

    private void handleNotModified(Http.Request request, Http.Response response, String etag) {
        if (request.method.equals("GET")) {
            response.status = 304;
        }
        response.setHeader("ETag", etag);
    }

    private void handleOk(Http.Request request, Http.Response response, VirtualFile file, String etag, long lastModified) {
        response.status = 200;
        response.print((Object)StyleCompressor.lessEngine.get(file.getRealFile(), false));
        response.setHeader("Last-Modified", Utils.getHttpDateFormatter().format(new Date(lastModified)));
        response.setHeader("ETag", etag);
    }
}

