/*
 * Decompiled with CFR 0.152.
 */
package press.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import play.exceptions.UnexpectedException;
import play.vfs.VirtualFile;
import press.PluginConfig;
import press.PressException;
import press.PressLogger;
import press.io.CompressedFile;
import press.io.FileIO;
import press.io.PressFileFilter;

public class OnDiskCompressedFile
extends CompressedFile {
    private Writer writer;
    private VirtualFile file;
    private File tmpOutputFile;

    public OnDiskCompressedFile(String filePath, String compressedDir) {
        super(filePath);
        this.file = FileIO.getVirtualFile(compressedDir + filePath);
    }

    public InputStream inputStream() {
        if (!this.exists()) {
            throw new PressException("Can't create InputStream. File does not exist");
        }
        return this.file.inputstream();
    }

    public String name() {
        return this.file.getName();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Writer startWrite() {
        if (this.writer != null) {
            return this.writer;
        }
        try {
            this.tmpOutputFile = OnDiskCompressedFile.getTmpOutputFile(this.file);
            if (this.tmpOutputFile == null) {
                return null;
            }
            VirtualFile dir = VirtualFile.open((String)this.file.getRealFile().getParent());
            if (!dir.exists() && !dir.getRealFile().mkdirs()) {
                throw new PressException("Could not create directory for compressed file output " + this.file.getRealFile().getAbsolutePath());
            }
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpOutputFile), "UTF-8"));
            return this.writer;
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public void close() {
        if (this.writer == null) {
            throw new UnexpectedException("Writer has not yet been created. Call getWriter() and write to it.");
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
        String msg = "Output written to temporary file\n%s\nMoving from tmp path to final path:\n%s";
        String tmpPath = this.tmpOutputFile.getAbsolutePath();
        String finalPath = this.file.getRealFile().getAbsolutePath();
        PressLogger.trace(msg, tmpPath, finalPath);
        if (!this.tmpOutputFile.renameTo(this.file.getRealFile())) {
            String ex = "Successfully wrote compressed file to temporary path\n" + tmpPath;
            ex = ex + "\nBut could not move it to final path\n" + finalPath;
            throw new PressException(ex);
        }
        this.tmpOutputFile = null;
    }

    private static File getTmpOutputFile(VirtualFile file) {
        String origPath = file.getRealFile().getAbsolutePath();
        File tmp = new File(origPath + ".tmp");
        if (tmp.exists()) {
            long tmpLastModified = tmp.lastModified();
            long now = System.currentTimeMillis();
            if (tmpLastModified < file.lastModified()) {
                return tmp;
            }
            if (now - tmpLastModified > (long)PluginConfig.maxCompressionTimeMillis) {
                return tmp;
            }
            while (tmp.exists()) {
                if (System.currentTimeMillis() - now > (long)PluginConfig.maxCompressionTimeMillis) {
                    throw new PressException("Timeout waiting for compressed file to be generated");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            return null;
        }
        return tmp;
    }

    public static int clearFileCache(String compressedDir, String extension) {
        PressLogger.trace("Deleting cached files", new Object[0]);
        VirtualFile dir = FileIO.getVirtualFile(compressedDir);
        if (!dir.exists() || !dir.isDirectory()) {
            return 0;
        }
        int deletedFiles = OnDiskCompressedFile.deletePressFilesRecursively(dir.getRealFile(), extension);
        PressLogger.trace("Deleted %d cached files", deletedFiles);
        return deletedFiles;
    }

    private static int deletePressFilesRecursively(File directory, String extension) {
        File[] subDirectories;
        File[] files;
        int deletedFiles = 0;
        PressFileFilter compressedFileFilter = new PressFileFilter(extension);
        for (File file : files = directory.listFiles(compressedFileFilter)) {
            if (!file.delete()) continue;
            ++deletedFiles;
        }
        FileFilter directoryFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        for (File subDir : subDirectories = directory.listFiles(directoryFilter)) {
            deletedFiles += OnDiskCompressedFile.deletePressFilesRecursively(subDir, extension);
        }
        return deletedFiles;
    }

    public long length() {
        if (!this.exists()) {
            throw new PressException("Can't get length. File does not exist");
        }
        return this.file.length();
    }
}

