/*
 * Decompiled with CFR 0.152.
 */
package press;

import java.lang.reflect.Method;
import play.PlayPlugin;
import press.CSSCompressor;
import press.JSCompressor;
import press.PluginConfig;

public class Plugin
extends PlayPlugin {
    static ThreadLocal<JSCompressor> jsCompressor = new ThreadLocal();
    static ThreadLocal<CSSCompressor> cssCompressor = new ThreadLocal();

    public void onApplicationStart() {
        PluginConfig.readConfig();
        JSCompressor.clearCache();
        CSSCompressor.clearCache();
    }

    public void beforeActionInvocation(Method actionMethod) {
        jsCompressor.set(new JSCompressor());
        cssCompressor.set(new CSSCompressor());
    }

    public static String compressedSingleJSUrl(String fileName) {
        return jsCompressor.get().compressedSingleFileUrl(fileName);
    }

    public static String compressedSingleCSSUrl(String fileName) {
        return cssCompressor.get().compressedSingleFileUrl(fileName);
    }

    public static String addJS(String fileName, boolean compress) {
        return jsCompressor.get().add(fileName, compress);
    }

    public static String addCSS(String fileName, boolean compress) {
        return cssCompressor.get().add(fileName, compress);
    }

    public static String compressedJSUrl() {
        return jsCompressor.get().compressedUrl();
    }

    public static String compressedCSSUrl() {
        return cssCompressor.get().compressedUrl();
    }

    public void afterActionInvocation() {
        if (jsCompressor.get() != null && cssCompressor.get() != null) {
            jsCompressor.get().saveFileList();
            cssCompressor.get().saveFileList();
        }
    }

    public static boolean enabled() {
        return PluginConfig.enabled;
    }
}

