/*
 * Decompiled with CFR 0.152.
 */
package controllers.press;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import play.exceptions.UnexpectedException;
import play.mvc.Controller;
import play.vfs.VirtualFile;
import press.CSSCompressor;
import press.JSCompressor;
import press.PluginConfig;

public class Press
extends Controller {
    public static void getCompressedJS(String key) {
        VirtualFile compressedFile = JSCompressor.getCompressedFile(key);
        if (compressedFile == null) {
            Press.renderBadResponse("JavaScript");
        }
        Press.renderBinary((File)compressedFile.getRealFile());
    }

    public static void getCompressedCSS(String key) {
        VirtualFile compressedFile = CSSCompressor.getCompressedFile(key);
        if (compressedFile == null) {
            Press.renderBadResponse("CSS");
        }
        Press.renderBinary((File)compressedFile.getRealFile());
    }

    public static void clearJSCache() {
        if (!PluginConfig.cacheClearEnabled) {
            Press.forbidden();
        }
        List<File> files = JSCompressor.clearCache();
        Press.renderText((Object)("Cleared " + files.size() + " files from cache"));
    }

    public static void clearCSSCache() {
        if (!PluginConfig.cacheClearEnabled) {
            Press.forbidden();
        }
        List<File> files = CSSCompressor.clearCache();
        Press.renderText((Object)("Cleared " + files.size() + " files from cache"));
    }

    private static void renderBadResponse(String fileType) {
        String response = "/*\n";
        response = response + "The compressed " + fileType + " file could not be generated.\n";
        response = response + "This can occur in two situations:\n";
        response = response + "1. The time between when the page was rendered by the ";
        response = response + "server and when the browser requested the compressed ";
        response = response + "file was greater than the timeout. (The timeout is ";
        response = response + "currently configured to be ";
        response = response + PluginConfig.compressionKeyStorageTime + ")\n";
        response = response + "2. There was an exception thrown while rendering the ";
        response = response + "page. Note that the press plugin compression will not ";
        response = response + "work in error pages (eg 404.html or 500.html).\n";
        response = response + "*/";
        Press.renderBinaryResponse(response);
    }

    private static void renderBinaryResponse(String response) {
        try {
            Press.renderBinary((InputStream)new ByteArrayInputStream(response.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

