/*
 * Decompiled with CFR 0.152.
 */
package play.modules.pusher;

import com.google.gson.Gson;
import play.Play;
import play.exceptions.UnexpectedException;
import play.libs.WS;
import play.modules.pusher.AuthData;
import play.modules.pusher.PresenceChannelData;
import play.modules.pusher.PusherUtil;

public class Pusher {
    private final String host = "api.pusherapp.com";
    private final String appId;
    private final String key;
    private final String secret;

    public Pusher() {
        if (!Play.configuration.containsKey("pusher.appId")) {
            throw new UnexpectedException("Module Pusher requires that you specify pusher.appId in your application.conf");
        }
        if (!Play.configuration.containsKey("pusher.key")) {
            throw new UnexpectedException("Module Pusher requires that you specify pusher.key in your application.conf");
        }
        if (!Play.configuration.containsKey("pusher.secret")) {
            throw new UnexpectedException("Module Pusher requires that you specify pusher.secret in your application.conf");
        }
        this.appId = Play.configuration.getProperty("pusher.appId");
        this.key = Play.configuration.getProperty("pusher.key");
        this.secret = Play.configuration.getProperty("pusher.secret");
    }

    public Pusher(String appId, String key, String secret) {
        this.appId = appId;
        this.key = key;
        this.secret = secret;
    }

    public WS.HttpResponse trigger(String channel, String event, String message) {
        return this.trigger(channel, event, message, null);
    }

    public WS.HttpResponse trigger(String channel, String event, String message, String socketId) {
        String path = "/apps/" + this.appId + "/channels/" + channel + "/events";
        String query = "auth_key=" + this.key + "&auth_timestamp=" + System.currentTimeMillis() / 1000L + "&auth_version=1.0" + "&body_md5=" + PusherUtil.md5(message) + "&name=" + event + (socketId != null ? "&socket_id=" + socketId : "");
        String signature = PusherUtil.sha256("POST\n" + path + "\n" + query, this.secret);
        String uri = "http://" + this.host + path + "?" + query + "&auth_signature=" + signature;
        return WS.url((String)uri).body((Object)message).post();
    }

    public String createAuthString(String socketId, String channel) {
        Gson gson = new Gson();
        String signature = PusherUtil.sha256(socketId + ":" + channel, this.secret);
        AuthData auth = new AuthData(this.key + ":" + signature);
        return gson.toJson((Object)auth);
    }

    public String createAuthString(String socketId, String channel, PresenceChannelData channelData) {
        Gson gson = new Gson();
        String jsonChannelData = gson.toJson((Object)channelData);
        String signature = PusherUtil.sha256(socketId + ":" + channel + ":" + jsonChannelData, this.secret);
        AuthData auth = new AuthData(this.key + ":" + signature, jsonChannelData);
        return gson.toJson((Object)auth);
    }
}

