/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import play.modules.rabbitmq.stats.Stats;

public class StatsService {
    protected static final ArrayList<String> instrumentedTasks = new ArrayList();
    protected static final HashMap<String, LinkedList<Long>> executionTimes = new HashMap();
    protected static final HashMap<String, Integer> consumerSuccessCount = new HashMap();
    protected static final HashMap<String, Integer> consumerFailedCount = new HashMap();
    protected static final HashMap<String, Integer> producerSuccessCount = new HashMap();
    protected static final HashMap<String, Integer> producerFailedCount = new HashMap();
    protected static final Object metricsLock = new Object();

    public static Stats queueStats(String queueName) {
        Stats stats = new Stats();
        if (consumerSuccessCount != null && consumerSuccessCount.containsKey(queueName)) {
            stats.setConsumerSuccessCount(new Long(consumerSuccessCount.get(queueName).intValue()));
        }
        if (consumerFailedCount != null && consumerFailedCount.containsKey(queueName)) {
            stats.setConsumerFailedCount(new Long(consumerFailedCount.get(queueName).intValue()));
        }
        if (producerSuccessCount != null && producerSuccessCount.containsKey(queueName)) {
            stats.setProducerSuccessCount(new Long(producerSuccessCount.get(queueName).intValue()));
        }
        if (producerFailedCount != null && producerFailedCount.containsKey(queueName)) {
            stats.setProducerFailedCount(new Long(producerFailedCount.get(queueName).intValue()));
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consumerUpdate(String queue, long time, boolean status, int retries) {
        Object object = metricsLock;
        synchronized (object) {
            if (!instrumentedTasks.contains(queue)) {
                instrumentedTasks.add(queue);
            }
            StatsService.updateExecutionTimes(queue, time);
            StatsService.updateConsumerResults(queue, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void producerUpdate(String queue, long time, boolean status, int retries) {
        Object object = metricsLock;
        synchronized (object) {
            if (!instrumentedTasks.contains(queue)) {
                instrumentedTasks.add(queue);
            }
            StatsService.updateExecutionTimes(queue, time);
            StatsService.updateProducerResults(queue, status);
        }
    }

    private static void updateExecutionTimes(String queue, long time) {
        if (!executionTimes.containsKey(queue)) {
            LinkedList<Long> timeList = new LinkedList<Long>();
            timeList.addFirst(time);
            executionTimes.put(queue, timeList);
        } else {
            LinkedList<Long> timeList = executionTimes.get(queue);
            if (timeList.size() == 10000) {
                timeList.removeLast();
            }
            timeList.addFirst(time);
            executionTimes.put(queue, timeList);
        }
    }

    private static void updateProducerResults(String queue, boolean status) {
        if (status) {
            if (!producerSuccessCount.containsKey(queue)) {
                producerSuccessCount.put(queue, 1);
            } else {
                int success = producerSuccessCount.get(queue);
                producerSuccessCount.put(queue, success + 1);
            }
        } else if (!producerFailedCount.containsKey(queue)) {
            producerFailedCount.put(queue, 1);
        } else {
            int failure = producerFailedCount.get(queue);
            producerFailedCount.put(queue, failure + 1);
        }
    }

    private static void updateConsumerResults(String queue, boolean status) {
        if (status) {
            if (!consumerSuccessCount.containsKey(queue)) {
                consumerSuccessCount.put(queue, 1);
            } else {
                int success = consumerSuccessCount.get(queue);
                consumerSuccessCount.put(queue, success + 1);
            }
        } else if (!consumerFailedCount.containsKey(queue)) {
            consumerFailedCount.put(queue, 1);
        } else {
            int failure = consumerFailedCount.get(queue);
            consumerFailedCount.put(queue, failure + 1);
        }
    }
}

