/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import play.Logger;
import play.Play;
import play.jobs.Job;
import play.modules.rabbitmq.RabbitMQPlugin;
import play.modules.rabbitmq.stats.StatisticsEvent;
import play.modules.rabbitmq.stats.StatisticsStream;
import play.modules.rabbitmq.util.ExceptionUtil;
import play.modules.rabbitmq.util.JSONMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RabbitMQConsumer<T>
extends Job<T> {
    public void doJob() {
        this.goGetHerSon();
    }

    protected abstract String queue();

    private void goGetHerSon() {
        RabbitMQPlugin plugin = (RabbitMQPlugin)((Object)Play.plugin(RabbitMQPlugin.class));
        Channel channel = null;
        QueueingConsumer consumer = null;
        block6: while (true) {
            try {
                while (true) {
                    if (channel == null) {
                        channel = this.createChannel(plugin);
                    }
                    if (consumer == null) {
                        consumer = this.createConsumer(channel, plugin);
                    }
                    QueueingConsumer.Delivery task = null;
                    task = consumer.nextDelivery();
                    if (task == null || task.getBody() == null) continue;
                    try {
                        long start = System.nanoTime();
                        T message = this.toObject(task.getBody());
                        new RabbitMQMessageConsumerJob<T>(this, message).now();
                        channel.basicAck(task.getEnvelope().getDeliveryTag(), false);
                        long executionTime = System.nanoTime() - start;
                        Logger.info((String)"Message %s has been consumed from queue %s (execution time: %s ms)", (Object[])new Object[]{message, this.queue(), executionTime});
                        StatisticsStream.add(new StatisticsEvent(this.queue(), StatisticsEvent.Type.CONSUMER, StatisticsEvent.Status.SUCCESS));
                        continue block6;
                    }
                    catch (Throwable t) {
                        Logger.error((String)"Error trying to acknowledge message delivery - Error: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(t)});
                        StatisticsStream.add(new StatisticsEvent(this.queue(), StatisticsEvent.Type.CONSUMER, StatisticsEvent.Status.ERROR));
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                channel = null;
                consumer = null;
                Logger.error((String)"Error creating consumer channel to RabbitMQ, retrying in a few seconds. Exception: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(t)});
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                    continue;
                }
            }
            break;
        }
    }

    protected abstract void consume(T var1);

    protected abstract Class getMessageType();

    protected Channel createChannel(RabbitMQPlugin plugin) throws Exception {
        Channel channel = plugin.createChannel(this.queue());
        return channel;
    }

    protected QueueingConsumer createConsumer(Channel channel, RabbitMQPlugin plugin) throws Exception {
        QueueingConsumer consumer = new QueueingConsumer(channel);
        channel.basicConsume(this.queue(), plugin.isAutoAck(), (Consumer)consumer);
        Logger.info((String)("RabbitMQ Consumer - Channel: %s, Consumer: %s " + channel), (Object[])new Object[]{consumer});
        return consumer;
    }

    protected T toObject(byte[] bytes) throws Exception {
        return (T)JSONMapper.getObject(this.getMessageType(), bytes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RabbitMQMessageConsumerJob<T>
    extends Job<T> {
        private T message;
        private RabbitMQConsumer consumer;

        public RabbitMQMessageConsumerJob(RabbitMQConsumer consumer, T message) {
            this.consumer = consumer;
            this.message = message;
        }

        public void doJob() {
            this.consumer.consume(this.message);
        }
    }
}

