/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.producer;

import com.rabbitmq.client.Channel;
import play.Logger;
import play.Play;
import play.jobs.Job;
import play.modules.rabbitmq.RabbitMQPlugin;
import play.modules.rabbitmq.producer.RabbitMQProducer;
import play.modules.rabbitmq.stats.StatisticsEvent;
import play.modules.rabbitmq.stats.StatisticsStream;
import play.modules.rabbitmq.util.ExceptionUtil;
import play.modules.rabbitmq.util.JSONMapper;

public abstract class RabbitMQPublisher {
    public static void publish(String queueName, Object message) {
        new RabbitMQPublisherJob(queueName, message).now();
    }

    protected static class RabbitMQPublisherJob
    extends Job {
        private Object message;
        private String queueName;

        public RabbitMQPublisherJob(String queueName, Object message) {
            this.queueName = queueName;
            this.message = message;
        }

        public void doJob() {
            try {
                long start = System.nanoTime();
                RabbitMQProducer producer = ((Object)((Object)this)).getClass().getAnnotation(RabbitMQProducer.class);
                if (producer == null && this.queueName == null) {
                    throw new RuntimeException("Please define annotation @RabbitMQProducer.");
                }
                RabbitMQPlugin plugin = (RabbitMQPlugin)((Object)Play.plugin(RabbitMQPlugin.class));
                Channel channel = plugin.createChannel(this.queueName);
                if (channel == null) {
                    throw new RuntimeException("Error creating a communication channel with RabbitMQ. Please verify the health of your RabbitMQ node and check your configuration.");
                }
                channel.basicPublish("", this.queueName, plugin.getBasicProperties(), this.getBytes());
                long executionTime = System.nanoTime() - start;
                Logger.info((String)"Message %s has been published to queue %s (execution time: %s ms)", (Object[])new Object[]{this.message, this.queueName, executionTime});
                StatisticsStream.add(new StatisticsEvent(this.queueName, StatisticsEvent.Type.PRODUCER, StatisticsEvent.Status.SUCCESS));
            }
            catch (Throwable t) {
                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                StatisticsStream.add(new StatisticsEvent(this.queueName, StatisticsEvent.Type.CONSUMER, StatisticsEvent.Status.ERROR));
            }
        }

        private byte[] getBytes() throws Exception {
            return JSONMapper.getBytes(this.message);
        }
    }
}

