/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.object;

import java.io.IOException;
import java.util.Arrays;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;

public class RawType
extends MessagePackObject {
    private byte[] bytes;

    RawType(byte[] bytes) {
        this.bytes = bytes;
    }

    RawType(String str) {
        try {
            this.bytes = str.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new MessageTypeException("type error");
        }
    }

    public static RawType create(byte[] bytes) {
        return new RawType(bytes);
    }

    public static RawType create(String str) {
        return new RawType(str);
    }

    public boolean isRawType() {
        return true;
    }

    public byte[] asByteArray() {
        return this.bytes;
    }

    public String asString() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new MessageTypeException("type error");
        }
    }

    public void messagePack(Packer pk) throws IOException {
        pk.packRaw(this.bytes.length);
        pk.packRawBody(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return Arrays.equals(((RawType)obj).bytes, this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public Object clone() {
        return new RawType((byte[])this.bytes.clone());
    }
}

