/** 
 * Copyright 2011 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * @author Felipe Oliveira (http://mashup.fm)
 * 
 */
package play.modules.rabbitmq.consumer;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

// TODO: Auto-generated Javadoc
/**
 * The listener interface for receiving rabbitMQMessage events. The class that
 * is interested in processing a rabbitMQMessage event implements this
 * interface, and the object created with that class is registered with a
 * component using the component's
 * <code>addRabbitMQMessageListener<code> method. When
 * the rabbitMQMessage event occurs, that object's appropriate
 * method is invoked.
 * 
 * @see RabbitMQMessageEvent
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface RabbitMQMessageListener {

	/**
	 * Queue.
	 * 
	 * @return the string
	 */
	public String queue();

}
