/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import play.Logger;
import play.Play;
import play.jobs.Job;
import play.modules.rabbitmq.RabbitMQPlugin;
import play.modules.rabbitmq.consumer.RabbitMQMessageConsumerJob;
import play.modules.rabbitmq.util.ExceptionUtil;
import play.modules.rabbitmq.util.JSONMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RabbitMQConsumer<T>
extends Job<T> {
    public static int retries = RabbitMQPlugin.retries();

    protected abstract void consume(T var1);

    protected Channel createChannel(RabbitMQPlugin plugin) throws Exception {
        Channel channel = plugin.createChannel(this.queue());
        return channel;
    }

    protected QueueingConsumer createConsumer(Channel channel, RabbitMQPlugin plugin) throws Exception {
        QueueingConsumer consumer = new QueueingConsumer(channel);
        channel.basicConsume(this.queue(), plugin.isAutoAck(), (Consumer)consumer);
        Logger.info((String)("RabbitMQ Consumer - Channel: %s, Consumer: %s " + channel), (Object[])new Object[]{consumer});
        return consumer;
    }

    public void doJob() {
        this.goGetHerSon();
    }

    protected abstract Class getMessageType();

    private void goGetHerSon() {
        RabbitMQPlugin plugin = (RabbitMQPlugin)((Object)Play.plugin(RabbitMQPlugin.class));
        Channel channel = null;
        QueueingConsumer consumer = null;
        block6: while (true) {
            try {
                while (true) {
                    if (channel == null) {
                        channel = this.createChannel(plugin);
                    }
                    if (consumer == null) {
                        consumer = this.createConsumer(channel, plugin);
                    }
                    QueueingConsumer.Delivery task = null;
                    task = consumer.nextDelivery();
                    if (task == null || task.getBody() == null) continue;
                    try {
                        T message = this.toObject(task.getBody());
                        new RabbitMQMessageConsumerJob<T>(channel, task.getEnvelope().getDeliveryTag(), this.queue(), this, message, this.retries()).now();
                        continue block6;
                    }
                    catch (Throwable t) {
                        Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                channel = null;
                consumer = null;
                Logger.error((String)"Error creating consumer channel to RabbitMQ, retrying in a few seconds. Exception: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(t)});
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                    continue;
                }
            }
            break;
        }
    }

    protected abstract String queue();

    protected int retries() {
        return retries;
    }

    protected T toObject(byte[] bytes) throws Exception {
        return (T)JSONMapper.getObject(this.getMessageType(), bytes);
    }
}

