/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import play.Logger;
import play.jobs.Job;
import play.modules.rabbitmq.consumer.RabbitMQConsumer;
import play.modules.rabbitmq.stats.StatisticsEvent;
import play.modules.rabbitmq.stats.StatisticsStream;
import play.modules.rabbitmq.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RabbitMQMessageConsumerJob<T>
extends Job<T> {
    private T message;
    private RabbitMQConsumer consumer;
    private int retries;
    private Channel channel;
    private long deliveryTag;
    private String queue;

    public RabbitMQMessageConsumerJob(Channel channel, long deliveryTag, String queue, RabbitMQConsumer consumer, T message, int retries) {
        this.consumer = consumer;
        this.message = message;
        this.retries = retries;
        this.channel = channel;
        this.deliveryTag = deliveryTag;
        this.queue = queue;
    }

    public void doJob() {
        boolean success = false;
        Throwable exception = null;
        for (int retryCount = 0; retryCount < this.retries + 1; ++retryCount) {
            if (retryCount > 0) {
                Logger.info((String)"Retrying to process message (%s) by consumer (%s) on queue (%s). Attempt %s of %s total retries.", (Object[])new Object[]{this.message, this.consumer, this.queue, retryCount, this.retries});
            }
            try {
                long start = System.nanoTime();
                this.consumer.consume(this.message);
                success = true;
                this.channel.basicAck(this.deliveryTag, false);
                long executionTime = System.nanoTime() - start;
                Logger.info((String)"Message %s from queue %s has been processed by consumer %s (execution time: %s ms)", (Object[])new Object[]{this.message, this.queue, this.consumer, executionTime});
                StatisticsStream.add(new StatisticsEvent(this.queue, StatisticsEvent.Type.CONSUMER, StatisticsEvent.Status.SUCCESS));
            }
            catch (Throwable t) {
                exception = t;
                Logger.error((String)"Error processing message (%s) with consumer (%s). Exception: %s", (Object[])new Object[]{this.message, this.consumer, ExceptionUtil.getStackTrace(t)});
                StatisticsStream.add(new StatisticsEvent(this.queue, StatisticsEvent.Type.CONSUMER, StatisticsEvent.Status.ERROR));
            }
            if (success) break;
        }
        if (!success) {
            Logger.error((String)"Final error processing message (%s) with consumer (%s). Last Exception: %s", (Object[])new Object[]{this.message, this.consumer, exception});
        }
    }
}

