/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.AnyTemplate;
import org.msgpack.template.GenericTemplate1;
import org.msgpack.template.TemplateRegistry;

public class CollectionTemplate
implements Template {
    private Template elementTemplate;

    public static void load() {
    }

    public CollectionTemplate(Template elementTemplate) {
        this.elementTemplate = elementTemplate;
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof Collection)) {
            if (target == null) {
                throw new MessageTypeException(new NullPointerException("target is null."));
            }
            throw new MessageTypeException("target is not Collection type: " + target.getClass());
        }
        Collection collection = (Collection)target;
        pk.packArray(collection.size());
        for (Object element : collection) {
            this.elementTemplate.pack(pk, element);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        LinkedList<Object> c;
        int length = pac.unpackArray();
        if (to == null) {
            c = new LinkedList<Object>();
        } else {
            c = (LinkedList<Object>)to;
            c.clear();
        }
        while (length > 0) {
            c.add(this.elementTemplate.unpack(pac, null));
            --length;
        }
        return c;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        LinkedList<Object> c;
        MessagePackObject[] array = from.asArray();
        if (to == null) {
            c = new LinkedList<Object>();
        } else {
            c = (LinkedList<Object>)to;
            c.clear();
        }
        for (MessagePackObject element : array) {
            c.add(this.elementTemplate.convert(element, null));
        }
        return c;
    }

    static {
        TemplateRegistry.registerGeneric(Collection.class, new GenericTemplate1(CollectionTemplate.class));
        TemplateRegistry.register(Collection.class, new CollectionTemplate(AnyTemplate.getInstance()));
    }
}

