/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.AbstractTemplate;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateBuildException;
import org.msgpack.template.builder.TemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdinalEnumTemplateBuilder
implements TemplateBuilder {
    @Override
    public Template buildTemplate(Type targetType) {
        Class targetClass = (Class)targetType;
        this.checkOrdinalEnumValidation(targetClass);
        Enum[] entries = (Enum[])targetClass.getEnumConstants();
        return new ReflectionOrdinalEnumTemplate(entries);
    }

    private void checkOrdinalEnumValidation(Class<?> targetClass) {
        if (!targetClass.isEnum()) {
            throw new TemplateBuildException("tried to build ordinal enum template of non-enum class");
        }
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        throw new UnsupportedOperationException(targetType.toString());
    }

    @Override
    public Template loadTemplate(Type targetType) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectionOrdinalEnumTemplate
    extends AbstractTemplate {
        protected Enum<?>[] entries;
        protected Map<Enum<?>, Integer> reverse;

        ReflectionOrdinalEnumTemplate(Enum<?>[] entries) {
            this.entries = entries;
            this.reverse = new HashMap();
            for (int i = 0; i < entries.length; ++i) {
                this.reverse.put(entries[i], i);
            }
        }

        @Override
        public void pack(Packer pk, Object target) throws IOException {
            Integer ord = this.reverse.get(target);
            if (ord == null) {
                throw new MessageTypeException();
            }
            pk.pack((int)ord);
        }

        @Override
        public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
            int ord = pac.unpackInt();
            if (this.entries.length <= ord) {
                throw new MessageTypeException();
            }
            return this.entries[ord];
        }

        @Override
        public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
            int ord = from.asInt();
            if (this.entries.length <= ord) {
                throw new MessageTypeException();
            }
            return this.entries[ord];
        }
    }
}

