/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.msgpack.AbstractTemplate;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.FieldEntry;
import org.msgpack.template.FieldEntryReader;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.IFieldEntryReader;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.CustomTemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionTemplateBuilder
extends CustomTemplateBuilder {
    IFieldEntryReader reader = new FieldEntryReader();

    @Override
    public IFieldEntryReader getFieldEntryReader() {
        return this.reader;
    }

    @Override
    public Template buildTemplate(Class<?> targetClass, IFieldEntry[] entries) {
        for (IFieldEntry e : entries) {
            Field f = ((FieldEntry)e).getField();
            int mod = f.getModifiers();
            if (Modifier.isPublic(mod)) continue;
            f.setAccessible(true);
        }
        ReflectionFieldEntry[] res = new ReflectionFieldEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            FieldEntry e = (FieldEntry)entries[i];
            Class<?> type = e.getType();
            if (!e.isAvailable()) {
                res[i] = new NullFieldEntry(e);
                continue;
            }
            if (type.equals(Boolean.TYPE)) {
                res[i] = new BooleanFieldEntry(e);
                continue;
            }
            if (type.equals(Byte.TYPE)) {
                res[i] = new ByteFieldEntry(e);
                continue;
            }
            if (type.equals(Short.TYPE)) {
                res[i] = new ShortFieldEntry(e);
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                res[i] = new IntFieldEntry(e);
                continue;
            }
            if (type.equals(Long.TYPE)) {
                res[i] = new LongFieldEntry(e);
                continue;
            }
            if (type.equals(Float.TYPE)) {
                res[i] = new FloatFieldEntry(e);
                continue;
            }
            if (type.equals(Double.TYPE)) {
                res[i] = new DoubleFieldEntry(e);
                continue;
            }
            Template tmpl = TemplateRegistry.lookup(e.getGenericType(), true);
            res[i] = new ObjectFieldEntry(e, tmpl);
        }
        return new ReflectionTemplate(targetClass, res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectionTemplate
    extends AbstractTemplate {
        protected Class<?> targetClass;
        protected ReflectionFieldEntry[] entries;
        protected int minimumArrayLength;

        ReflectionTemplate(Class<?> targetClass, ReflectionFieldEntry[] entries) {
            this.targetClass = targetClass;
            this.entries = entries;
            this.minimumArrayLength = 0;
            for (int i = 0; i < entries.length; ++i) {
                ReflectionFieldEntry e = entries[i];
                if (!e.isRequired() && !e.isNullable()) continue;
                this.minimumArrayLength = i + 1;
            }
        }

        @Override
        public void pack(Packer pk, Object target) throws IOException {
            try {
                pk.packArray(this.entries.length);
                for (ReflectionFieldEntry e : this.entries) {
                    if (!e.isAvailable()) {
                        pk.packNil();
                        continue;
                    }
                    Object obj = e.getField().get(target);
                    if (obj == null) {
                        if (!e.isNullable() && !e.isOptional()) {
                            throw new MessageTypeException();
                        }
                        pk.packNil();
                        continue;
                    }
                    e.pack(obj, pk);
                }
            }
            catch (MessageTypeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }

        @Override
        public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
            try {
                int max;
                int i;
                int length;
                if (to == null) {
                    to = this.targetClass.newInstance();
                }
                if ((length = pac.unpackArray()) < this.minimumArrayLength) {
                    throw new MessageTypeException();
                }
                for (i = 0; i < this.minimumArrayLength; ++i) {
                    ReflectionFieldEntry e = this.entries[i];
                    if (!e.isAvailable()) {
                        pac.unpackObject();
                        continue;
                    }
                    if (pac.tryUnpackNull()) {
                        if (e.isRequired()) {
                            throw new MessageTypeException();
                        }
                        if (e.isOptional()) continue;
                        e.setNull(to);
                        continue;
                    }
                    e.unpack(to, pac);
                }
                int n = max = length < this.entries.length ? length : this.entries.length;
                while (i < max) {
                    ReflectionFieldEntry e = this.entries[i];
                    if (!e.isAvailable()) {
                        pac.unpackObject();
                    } else if (!pac.tryUnpackNull()) {
                        e.unpack(to, pac);
                    }
                    ++i;
                }
                while (i < length) {
                    pac.unpackObject();
                    ++i;
                }
                return to;
            }
            catch (MessageTypeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }

        @Override
        public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
            try {
                int max;
                int i;
                MessagePackObject[] array;
                int length;
                if (to == null) {
                    to = this.targetClass.newInstance();
                }
                if ((length = (array = from.asArray()).length) < this.minimumArrayLength) {
                    throw new MessageTypeException();
                }
                for (i = 0; i < this.minimumArrayLength; ++i) {
                    ReflectionFieldEntry e = this.entries[i];
                    if (!e.isAvailable()) continue;
                    MessagePackObject obj = array[i];
                    if (obj.isNil()) {
                        if (e.isRequired()) {
                            throw new MessageTypeException();
                        }
                        if (e.isOptional()) continue;
                        e.setNull(to);
                        continue;
                    }
                    e.convert(to, obj);
                }
                int n = max = length < this.entries.length ? length : this.entries.length;
                while (i < max) {
                    MessagePackObject obj;
                    ReflectionFieldEntry e = this.entries[i];
                    if (e.isAvailable() && !(obj = array[i]).isNil()) {
                        e.convert(to, obj);
                    }
                    ++i;
                }
                return to;
            }
            catch (MessageTypeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }
    }

    static class DoubleFieldEntry
    extends ReflectionFieldEntry {
        DoubleFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
            pac.pack((double)((Double)target));
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.getField().setDouble(target, obj.asDouble());
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            this.getField().setDouble(target, pac.unpackDouble());
        }
    }

    static class FloatFieldEntry
    extends ReflectionFieldEntry {
        FloatFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
            pac.pack(((Float)target).floatValue());
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.getField().setFloat(target, obj.asFloat());
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            this.getField().setFloat(target, pac.unpackFloat());
        }
    }

    static class LongFieldEntry
    extends ReflectionFieldEntry {
        LongFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
            pac.pack((long)((Long)target));
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.getField().setLong(target, obj.asLong());
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            this.getField().setLong(target, pac.unpackLong());
        }
    }

    static class IntFieldEntry
    extends ReflectionFieldEntry {
        IntFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
            pac.pack((int)((Integer)target));
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.getField().setInt(target, obj.asInt());
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            this.getField().setInt(target, pac.unpackInt());
        }
    }

    static class ShortFieldEntry
    extends ReflectionFieldEntry {
        ShortFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
            pac.pack((short)((Short)target));
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.getField().setShort(target, obj.asShort());
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            this.getField().setShort(target, pac.unpackShort());
        }
    }

    static class ByteFieldEntry
    extends ReflectionFieldEntry {
        ByteFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
            pac.pack((byte)((Byte)target));
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.getField().setByte(target, obj.asByte());
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            this.getField().setByte(target, pac.unpackByte());
        }
    }

    static class BooleanFieldEntry
    extends ReflectionFieldEntry {
        BooleanFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
            pac.pack((boolean)((Boolean)target));
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.getField().setBoolean(target, obj.asBoolean());
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            this.getField().setBoolean(target, pac.unpackBoolean());
        }
    }

    static class ObjectFieldEntry
    extends ReflectionFieldEntry {
        private Template template;

        ObjectFieldEntry(FieldEntry e, Template template) {
            super(e);
            this.template = template;
        }

        public void pack(Object target, Packer pac) throws IOException {
            this.template.pack(pac, target);
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            Field f = this.getField();
            Class<?> type = f.getType();
            Object fieldReference = f.get(target);
            Object valueReference = this.template.convert(obj, fieldReference);
            if (valueReference != fieldReference) {
                f.set(target, valueReference);
            }
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
            Field f = this.getField();
            Class<?> type = f.getType();
            Object fieldReference = f.get(target);
            Object valueReference = this.template.unpack(pac, fieldReference);
            if (valueReference != fieldReference) {
                f.set(target, valueReference);
            }
        }
    }

    static class NullFieldEntry
    extends ReflectionFieldEntry {
        NullFieldEntry(FieldEntry e) {
            super(e);
        }

        public void pack(Object target, Packer pac) throws IOException {
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
        }

        public void unpack(Object target, Unpacker pac) throws IOException, MessageTypeException, IllegalAccessException {
        }
    }

    static abstract class ReflectionFieldEntry
    extends FieldEntry {
        ReflectionFieldEntry(FieldEntry e) {
            super(e.getField(), e.getOption());
        }

        public abstract void pack(Object var1, Packer var2) throws IOException;

        public abstract void convert(Object var1, MessagePackObject var2) throws MessageTypeException, IllegalAccessException;

        public abstract void unpack(Object var1, Unpacker var2) throws IOException, MessageTypeException, IllegalAccessException;

        public void setNull(Object target) throws IllegalAccessException {
            this.getField().set(target, null);
        }
    }
}

