/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.rabbitmq.stats.StatsService;
import play.modules.rabbitmq.util.ExceptionUtil;
import play.modules.rabbitmq.util.MsgMapper;

public class RabbitMQPlugin
extends PlayPlugin {
    public static final ConnectionFactory factory = new ConnectionFactory();
    private static MsgMapper mapper = null;
    private static StatsService statsService = new StatsService();

    public void onApplicationStart() {
        factory.setHost(RabbitMQPlugin.getHost());
        factory.setPort(RabbitMQPlugin.getPort());
        factory.setUsername(RabbitMQPlugin.getUserName());
        factory.setPassword(RabbitMQPlugin.getPassword());
        factory.setVirtualHost(RabbitMQPlugin.getVhost());
    }

    public static StatsService statsService() {
        return statsService;
    }

    public static MsgMapper mapper() {
        if (mapper != null) {
            return mapper;
        }
        String s = Play.configuration.getProperty("rabbitmq.msgmapper");
        if (s != null && StringUtils.isNotBlank((String)s)) {
            try {
                mapper = MsgMapper.Type.valueOf(s).get();
            }
            catch (Throwable t) {
                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                mapper = MsgMapper.Type.json.get();
            }
        } else {
            mapper = MsgMapper.Type.json.get();
        }
        Logger.info((String)"RabbitMQ Message Mapper: %s", (Object[])new Object[]{mapper});
        if (mapper == null) {
            throw new RuntimeException("RabbitMQ Message Mapper is null! Config Parameter 'rabbitmq.msgmapper': " + s);
        }
        return mapper;
    }

    protected Channel createChannel() {
        Channel channel = null;
        int attempts = 0;
        while (true) {
            Logger.info((String)("Attempting to connect to queue: attempt " + ++attempts), (Object[])new Object[0]);
            try {
                Connection connection = this.getConnection();
                channel = connection.createChannel();
            }
            catch (IOException e) {
                Logger.error((String)"Error creating RabbitMQ channel, retrying in 5 secs - Exception: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(e)});
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            break;
        }
        return channel;
    }

    public Channel createChannel(String queue) throws Exception {
        int attempts = 0;
        RabbitMQPlugin plugin = (RabbitMQPlugin)((Object)Play.plugin(RabbitMQPlugin.class));
        Logger.info((String)"Initializing connections to RabbitMQ instance (%s:%s), Queue: %s", (Object[])new Object[]{RabbitMQPlugin.getHost(), RabbitMQPlugin.getPort(), queue});
        Channel channel = this.createChannel();
        if (RabbitMQPlugin.isBasicQos()) {
            int prefetchCount = 1;
            channel.basicQos(prefetchCount);
        }
        while (true) {
            Logger.debug((String)("Retry " + ++attempts), (Object[])new Object[0]);
            try {
                new QueueingConsumer(channel);
                channel.exchangeDeclare(queue, plugin.getExchangeType(), true);
                channel.queueDeclare(queue, plugin.isDurable(), false, false, null);
                channel.queueBind(queue, queue, queue);
                Logger.info((String)("RabbitMQ Task Channel Available: " + channel), (Object[])new Object[0]);
                return channel;
            }
            catch (Throwable t) {
                Logger.error((String)"Error establishing a connection to RabbitMQ, will keep retrying - Exception: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(t)});
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                }
                continue;
            }
            break;
        }
    }

    public static String getHost() {
        String s = Play.configuration.getProperty("rabbitmq.host");
        if (s == null) {
            return "localhost";
        }
        return s;
    }

    public static int getPort() {
        String s = Play.configuration.getProperty("rabbitmq.port");
        if (s == null) {
            return 5672;
        }
        return Integer.parseInt(s);
    }

    public static String getUserName() {
        String s = Play.configuration.getProperty("rabbitmq.username");
        if (s == null) {
            return "guest";
        }
        return s;
    }

    public static String getPassword() {
        String s = Play.configuration.getProperty("rabbitmq.password");
        if (s == null) {
            return "guest";
        }
        return s;
    }

    public static boolean isAutoAck() {
        boolean autoAck = false;
        String s = Play.configuration.getProperty("rabbitmq.autoAck");
        if (s == null) {
            return autoAck;
        }
        return Boolean.parseBoolean(s);
    }

    public static boolean isBasicQos() {
        boolean basicQos = true;
        String s = Play.configuration.getProperty("rabbitmq.basicQos");
        if (s == null) {
            return basicQos;
        }
        return Boolean.parseBoolean(s);
    }

    public static int retries() {
        int defaultRetries = 5;
        try {
            return Integer.valueOf(Play.configuration.getProperty("rabbitmq.retries", String.valueOf(defaultRetries)));
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
            return defaultRetries;
        }
    }

    public static boolean isDurable() {
        boolean durable = true;
        String s = Play.configuration.getProperty("rabbitmq.durable");
        if (s == null) {
            return durable;
        }
        return Boolean.parseBoolean(s);
    }

    public static AMQP.BasicProperties getBasicProperties() {
        if (!RabbitMQPlugin.isDurable()) {
            return null;
        }
        AMQP.BasicProperties b = MessageProperties.PERSISTENT_TEXT_PLAIN;
        return b;
    }

    public static String getExchangeType() {
        String s = Play.configuration.getProperty("rabbitmq.exchangeType");
        if (s == null) {
            return "direct";
        }
        return s;
    }

    public static String getVhost() {
        String s = Play.configuration.getProperty("rabbitmq.vhost");
        if (s == null) {
            return "/";
        }
        return s;
    }

    public Connection getConnection() throws IOException {
        return factory.newConnection();
    }
}

