/*
 * Decompiled with CFR 0.152.
 */
package play.modules.rabbitmq.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.codehaus.jackson.map.ObjectMapper;
import play.Logger;
import play.modules.rabbitmq.util.ExceptionUtil;

public interface MsgMapper {
    public byte[] getBytes(Object var1) throws Exception;

    public Object getObject(Class var1, byte[] var2) throws Exception;

    public static class JSON
    implements MsgMapper {
        private transient ObjectMapper mapper = new ObjectMapper();

        public byte[] getBytes(Object object) throws Exception {
            String value = this.mapper.writeValueAsString(object);
            return value.getBytes();
        }

        public Object getObject(Class clazz, byte[] object) throws Exception {
            Object data = this.mapper.readValue(new String(object), clazz);
            return data;
        }
    }

    public static class POJO
    implements MsgMapper {
        public byte[] getBytes(Object object) throws Exception {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            out.close();
            byte[] bytes = bos.toByteArray();
            bos.close();
            return bytes;
        }

        public Object getObject(Class clazz, byte[] object) throws Exception {
            ByteArrayInputStream bis = new ByteArrayInputStream(object);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        pojo(POJO.class),
        json(JSON.class);

        private Class clazz;

        private Type(Class clazz) {
            this.clazz = clazz;
        }

        public MsgMapper get() {
            try {
                return (MsgMapper)this.clazz.newInstance();
            }
            catch (Throwable t) {
                Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
                throw new RuntimeException(t.fillInStackTrace());
            }
        }
    }
}

