/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.object;

import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.object.BigIntegerTypeIMPL;
import org.msgpack.object.IntegerType;
import org.msgpack.object.ShortIntegerTypeIMPL;

class LongIntegerTypeIMPL
extends IntegerType {
    private long value;

    LongIntegerTypeIMPL(long value) {
        this.value = value;
    }

    public byte asByte() {
        if (this.value > 127L) {
            throw new MessageTypeException("type error");
        }
        return (byte)this.value;
    }

    public short asShort() {
        if (this.value > 32767L) {
            throw new MessageTypeException("type error");
        }
        return (short)this.value;
    }

    public int asInt() {
        if (this.value > Integer.MAX_VALUE) {
            throw new MessageTypeException("type error");
        }
        return (int)this.value;
    }

    public long asLong() {
        return this.value;
    }

    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void messagePack(Packer pk) throws IOException {
        pk.packLong(this.value);
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            if (obj.getClass() == ShortIntegerTypeIMPL.class) {
                return this.value == ((ShortIntegerTypeIMPL)obj).longValue();
            }
            if (obj.getClass() == BigIntegerTypeIMPL.class) {
                return BigInteger.valueOf(this.value).equals(((BigIntegerTypeIMPL)obj).bigIntegerValue());
            }
            return false;
        }
        return ((LongIntegerTypeIMPL)obj).value == this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public Object clone() {
        return new LongIntegerTypeIMPL(this.value);
    }
}

